% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_cache.R
\name{set_cache}
\alias{set_cache}
\title{Cache a vector in the graph}
\usage{
set_cache(graph, to_cache, name = NULL, col = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{to_cache}{any vector or data
frame. If a data frame is supplied
then a single column for the vector
to pull must be provided in the
\code{col} argument.}

\item{name}{an optional name for the
cached vector.}

\item{col}{if a data frame is provided
in \code{to_cache} then a column name
from that data frame must provided here.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Place any vector in the
cache of a graph object of class
\code{dgr_graph}.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 22,
    set_seed = 23)

# Get the closeness values for
# all nodes from `1` to `10` and
# store in the graph's cache
graph <-
  graph \%>\%
  set_cache(
    name = "closeness_vector",
    to_cache = get_closeness(.),
    col = "closeness")

# Get the graph's cache
graph \%>\%
  get_cache(
    name = "closeness_vector")

# Get the difference of betweenness
# and closeness values for nodes in
# the graph and store the vector in
# the graph's cache
graph <-
  graph \%>\%
  set_cache(
    name = "difference",
    to_cache =
      get_betweenness(.)$betweenness -
        get_closeness(.)$closeness)

# Get the graph's cache
graph \%>\%
  get_cache(
    name = "difference")
}
