% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{GetDeltaMethodParameters}
\alias{GetDeltaMethodParameters}
\title{GetDeltaMethodParameters}
\usage{
GetDeltaMethodParameters(mu, covmat = NULL, MaskRho = FALSE)
}
\arguments{
\item{mu}{A numeric vector output from DE()$par}

\item{covmat}{A numeric matrix output from DE()$vcov}

\item{MaskRho}{The output from DE()$MaskRho}
}
\value{
A list containing the parameters of the normal distribution after transforming the coavariance variables to a positive definite space
}
\description{
Transforms the mean and variance covariance matrix of the estimators in an unrestricted space to a positive definite space for the delta method.
}
\examples{

set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)
df = data.frame(Y = Y, X1 = Xgen[,1], X2 = Xgen[,2])

results = DE(formula = Y ~ X1 | X2, data = df)

GetDeltaMethodParameters(results$par,results$vcov,results$MaskRho)

}
