% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateFrankCopula.R
\name{bivariateFrank}
\alias{bivariateFrank}
\alias{cBivariateFrank}
\alias{cdBivariateFrank}
\alias{crBivariateFrank}
\title{Bivariate Frank Copula}
\usage{
cBivariateFrank(u1, u2, dependencyParameter, ...)

cdBivariateFrank(u1, u2, dependencyParameter, ...)

crBivariateFrank(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameter.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{cBivariateFrank}}}{ returns the value of the copula.}
    \item{\code{\link{cdBivariateFrank}}}{ returns the value of the density function associated to the copula.}
    \item{\code{\link{crBivariateFrank}}}{ returns simulated values of the copula.}
  }
}
\description{
Computes CDF, PDF and simulations of the bivariate Frank copula.
}
\details{
The bivariate Frank copula has CDF :
}
\examples{
cBivariateFrank(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

cdBivariateFrank(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

crBivariateFrank(numberSimulations = 10, seed = 42, dependencyParameter = 0.2)

}
