% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\name{Norm}
\alias{Norm}
\alias{expValNorm}
\alias{varNorm}
\alias{expValLimNorm}
\alias{expValTruncNorm}
\alias{stopLossNorm}
\alias{meanExcessNorm}
\alias{VatRNorm}
\alias{TVatRNorm}
\alias{mgfNorm}
\title{Normal Distribution}
\usage{
expValNorm(mean, sd)

varNorm(mean, sd)

expValLimNorm(d, mean = 0, sd = 1)

expValTruncNorm(d, mean = 0, sd = 1, less.than.d = TRUE)

stopLossNorm(d, mean = 0, sd = 1)

meanExcessNorm(d, mean = 0, sd = 1)

VatRNorm(kap, mean = 0, sd = 1)

TVatRNorm(kap, mean = 0, sd = 1)

mgfNorm(t, mean = 0, sd = 1)
}
\arguments{
\item{mean}{mean (location) parameter \eqn{\mu}{mu}.}

\item{sd}{standard deviation \eqn{\sigma}{sigma}, must be positive.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{expValNorm}}}{ gives the expected value.}
    \item{\code{\link{varNorm}}}{ gives the variance.}
    \item{\code{\link{expValLimNorm}}}{ gives the limited mean.}
    \item{\code{\link{expValTruncNorm}}}{ gives the truncated mean.}
    \item{\code{\link{stopLossNorm}}}{ gives the stop-loss.}
    \item{\code{\link{meanExcessNorm}}}{ gives the mean excess loss.}
    \item{\code{\link{VatRNorm}}}{ gives the Value-at-Risk.}
    \item{\code{\link{TVatRNorm}}}{ gives the Tail Value-at-Risk.}
    \item{\code{\link{mgfNorm}}}{ gives the moment generating function (MGF).}
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Normal distribution
}
\details{
The Normal distribution with mean \eqn{\mu}{mu} and standard deviation
\eqn{\sigma}{sigma} has density:
  \deqn{\frac{1}{\sqrt{2\pi}\sigma}\textrm{e}^{-\frac{1}{2}\left(\frac{x - \mu}{\sigma}\right)^2}}{f(x) = e^(-(1/2) ((x - mu)/sigma)^2) / ((2 pi)^(1/2) sigma}
for \eqn{x \in \mathcal{R}}{x real}, \eqn{\mu \in \mathcal{R}, \sigma > 0}{mu real, sigma > 0}.
}
\note{
Function VatRNorm is a wrapper of the \code{\link[stats]{qnorm}}
function from the stats package.
}
\examples{
expValNorm(mean = 3, sd = 5)

varNorm(mean = 3, sd = 5)

expValLimNorm(d = 2, mean = 2, sd = 5)

expValTruncNorm(d = 2, mean = 2, sd = 5)

stopLossNorm(d = 2, mean = 2, sd = 5)

meanExcessNorm(d = 2, mean = 2, sd = 5)

VatRNorm(kap = 0.8, mean = 3, sd = 5)

TVatRNorm(kap = 0.8, mean = 2, sd = 5)

mgfNorm(t = 1, mean = 3, sd = 5)

}
