plotPDF <- function(dir,
	singleFile="",
	selectList="",
	sampleMask="",
	theta1=50.,
	theta2=30.,
	excludeEarly=TRUE,
	earlyCutoff=3.0,
	excludeLate=FALSE,
	lateCutoff=3.0,
	includeShoulders=TRUE,
	shoulderCutoff=0.1,
	t1Cutoff=1.0,
	t2Cutoff=1.0,
	t1SlopeWindow=1.0,
	t2SlopeWindow=1.0,
	scoreFile="",
	showFlorSmooth=TRUE,
	showDFlorSmooth=TRUE,
	useLasso=TRUE,
	modelFile="",
	xrangeOverride=FALSE,
	xrangemin=100,
	xrangemax=75,
	rejectsFile="",
	statsFile="",
	progressFunc=NULL){

    processDivMelt(dir=dir,
	singleFile=singleFile,
	selectList=selectList,
	sampleMask=sampleMask,
	theta1=theta1,
	theta2=theta2,
	format="pdf",
	showStats=TRUE,
	excludeEarly=excludeEarly,
	earlyCutoff=earlyCutoff,
	excludeLate=excludeLate,
	lateCutoff=lateCutoff,
	includeShoulders=includeShoulders,
	shoulderCutoff=shoulderCutoff,
	t1Cutoff=t1Cutoff,
	t2Cutoff=t2Cutoff,
	t1SlopeWindow=t1SlopeWindow,
	t2SlopeWindow=t2SlopeWindow,
	scoreFile=scoreFile,
	dataFile="",
	showFlorSmooth=showFlorSmooth,
	showDFlorSmooth=showDFlorSmooth,
	useLasso=useLasso,
	modelFile=modelFile,
	rejectsFile=rejectsFile,
	statsFile=statsFile,
	xrangeOverride=xrangeOverride,
	xrangemin=xrangemin,
	xrangemax=xrangemax,
	progressFunc=progressFunc)
}

plotPNG <- function(dir,
	singleFile="",
	selectList="",
	sampleMask="",
	theta1=50.,
	theta2=30.,
	excludeEarly=TRUE,
	earlyCutoff=3.0,
	excludeLate=FALSE,
	lateCutoff=1.0,
	includeShoulders=TRUE,
	showFlorSmooth=FALSE,
	showDFlorSmooth=FALSE,
	shoulderCutoff=0.1,
	t1Cutoff=1.0,
	t2Cutoff=1.0,
	t1SlopeWindow=1.0,
	t2SlopeWindow=1.0,
	xrangeOverride=FALSE,
	xrangemin=100,
	xrangemax=75,
	progressFunc=NULL){

    processDivMelt(dir=dir,
	singleFile=singleFile,
	selectList=selectList,
	sampleMask=sampleMask,
	theta1=theta1,
	theta2=theta2,
	format="png",
	showStats=FALSE,
	excludeEarly=excludeEarly,
	earlyCutoff=earlyCutoff,
	excludeLate=excludeLate,
	lateCutoff=lateCutoff,
	includeShoulders=includeShoulders,
	shoulderCutoff=shoulderCutoff,
	t1Cutoff=t1Cutoff,
	t2Cutoff=t2Cutoff,
	t1SlopeWindow=t1SlopeWindow,
	t2SlopeWindow=t2SlopeWindow,
	scoreFile="",
	dataFile="",
	showFlorSmooth=showFlorSmooth,
	showDFlorSmooth=showDFlorSmooth,
	useLasso=TRUE,
	modelFile="",
	rejectsFile="",
	statsFile="",
	xrangeOverride=xrangeOverride,
	xrangemin=xrangemin,
	xrangemax=xrangemax,
	progressFunc=progressFunc)
}
