% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-ContainerProvider.R,
%   R/dummyContainer.R
\name{registerParallelBackend}
\alias{registerParallelBackend}
\alias{deregisterParallelBackend}
\alias{registerParallelBackend,DummyContainer-method}
\alias{deregisterParallelBackend,DummyContainer-method}
\title{Register/deregister the parallel backend}
\usage{
registerParallelBackend(container, cluster, verbose, ...)

deregisterParallelBackend(container, cluster, verbose, ...)

\S4method{registerParallelBackend}{DummyContainer}(container, cluster, verbose, ...)

\S4method{deregisterParallelBackend}{DummyContainer}(container, cluster, verbose, ...)
}
\arguments{
\item{container}{The worker container.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}

\item{...}{The additional parameter that will be passed to the registration function}
}
\value{
No return value
}
\description{
Register/deregister the parallel backend. These methods will be dispatched based on
the \emph{worker} container. The parallel framework depends on the container image.
If the container uses the \code{foreach} framework, there is no need
to define \code{deregisterParallelBackend} as its default method will deregister the
foreach backend. There is no default method defined for \code{registerParallelBackend}.
}
\section{Functions}{
\itemize{
\item \code{registerParallelBackend,DummyContainer-method}: method for the dummy container

\item \code{deregisterParallelBackend,DummyContainer-method}: method for the dummy container
}}

