% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{graph_metrics}
\alias{graph_metrics}
\title{Analysis of metrics of an iGraph object}
\usage{
graph_metrics(graph, verbose = TRUE, return = FALSE)
}
\arguments{
\item{graph}{[igraph] iGraph object to analyze.}

\item{verbose}{[bool] If TRUE graph information is printed.}

\item{return}{[bool] If TRUE graph information is returned from function.}
}
\value{
Named list of metrics including vertex count, edge count, number of components,
size of largest component and the relative frequency of zero degree vertices.
}
\description{
This helper function prints or returns multiple metrics of arbitrary
iGraph graph object.
}
\examples{
adj_mat <- matrix(rnorm(36), nrow=6)
graph <- igraph::graph_from_adjacency_matrix(adj_mat)
DrDimont::graph_metrics(graph, verbose=TRUE, return=FALSE)


}
