% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.CEG.network.R
\name{CEG.network.graph}
\alias{CEG.network.graph}
\title{Plot The Pathway-CEG Network for A Drug}
\usage{
CEG.network.graph(path.analysis.res = path.analysis.res,
  pathway.FDR.cutoff = 0.1, drug.name = NULL, pathway.name = NULL,
  show.plot = TRUE)
}
\arguments{
\item{path.analysis.res}{The pathway analysis results. Output of function pathway.analysis().}

\item{pathway.FDR.cutoff}{The FDR threshold to select significant drug specific pathways and the default is 0.1.}

\item{drug.name}{The name of the drug user would like to analyze.The specified drug name should among those that are listed in the output table of function network.graph().}

\item{pathway.name}{The name of the pathway user would like to analyze. The specified pathway name should among those that are listed in the output table of function network.graph().}

\item{show.plot}{True or False, specifying if you want to show the pathway-CEG plot for a specific drug and pathway.}
}
\description{
This function allows user to plot the pathway-CEG network for a specified pathway in a specified drug.
}
\examples{

## get the Dr. Insight drug identification results
drug.ident.res = drug.ident(query.data = example.disease, cmap.ref.profiles = example.drug.profiles,
                 repurposing.unit = "treatment", connectivity = "negative")

## load in example pathway data
data("example.pathway")

## Performe pathway analysis (for the drugs that are identified by ident.drug())
path.analysis.res = pathway.analysis(drug.ident.res = drug.ident.res,
                    pathway.list = example.pathway,drug.FDR.cutoff = 0.5)

path.CEG.network = CEG.network.graph(path.analysis.res = path.analysis.res,
                  pathway.FDR.cutoff = 0.5,drug.name = "drug1",
                  pathway.name = "pathway5", show.plot = TRUE)
}
\keyword{CEG}
\keyword{Drug}
\keyword{network}
\keyword{pathway}
