% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{postProcess}
\alias{postProcess}
\alias{DynComm.postProcess}
\title{postProcess(actions)}
\usage{
DynComm.postProcess(dyncomm,actions)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}

\item{actions}{A list of post processing actions/steps}
}
\value{
FALSE if any kind of error occurred. Otherwise, TRUE
}
\description{
This method receives a list of actions to perform in post processing in the 
same order they are listed from left to right.
}
\details{
Several actions of the same type are allowed. They receive an internal ID
number that starts at one and increments by one unit with each action of the 
same type. Later, this ID can be used to select the intended action and get 
results from it.

Post processing can be reset (removed) be setting actions to NULL (default 
value) or passing an empty list.

The format of the actions is a list of action. Each action is a list of the
action name (see \code{\link{POSTPROCESSING}}) and parameters. The parameters
is a matrix of two columns, the first having the name of the parameter and, 
the second, the value of the parameter. The parameters is optional, and may 
be missing, in which case default values are used, if required at all.

The parameters accepted by each post processing algorithm can be found on the
help page of each respective algorithm.

This slighty awkward syntax is due to R not supporting matrix of matrices.
}
\examples{
library(DynComm)
parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
  dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,parameters)
  dc$addRemoveEdges(
   matrix(
      c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,12,13,1,1,1,2,2,2,18,12,19,20,2,3,11,12,4,9,5,9,22)
      ,ncol=2)
  )
  dc$postProcess(
    list(
 	     list(POSTPROCESSING$DENSOPT)
  	)
  )
 dc$select(POSTPROCESSING$DENSOPT)  #selects the results of densopt
 dc$select(POSTPROCESSING$NONE)  #selects the main algorithm results
 dc$postProcess(NULL)  #remove post processing
 ## or just
 ## dc$postProcess()

}
\seealso{
\code{\link{DynComm}} 
, \code{\link{select}} 
, \code{\link{POSTPROCESSING}}
}
\author{
poltergeist0
}
