% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_VIMP.R
\name{plot_VIMP}
\alias{plot_VIMP}
\title{Compute the VIMP statistic}
\usage{
plot_VIMP(DynForest_obj, PCT = FALSE, ordering = TRUE)
}
\arguments{
\item{DynForest_obj}{\code{DynForest} object}

\item{PCT}{Display VIMP statistic in pourcentage. Default value is FALSE.}

\item{ordering}{Order predictors according to VIMP value. Default value is TRUE.}
}
\value{
Display the VIMP for each predictor
}
\description{
Compute the VIMP statistic
}
\examples{
\donttest{
data(pbc2)

# Sample 100 subjects
set.seed(1234)
id <- unique(pbc2$id)
id_sample <- sample(id, 100)
id_row <- which(pbc2$id\%in\%id_sample)

pbc2_train <- pbc2[id_row,]

timeData_train <- pbc2_train[,c("id","time",
                                "serBilir","SGOT",
                                "albumin","alkaline")]

# Create object with longitudinal association for each predictor
timeVarModel <- list(serBilir = list(fixed = serBilir ~ time,
                                     random = ~ time),
                     SGOT = list(fixed = SGOT ~ time + I(time^2),
                                 random = ~ time + I(time^2)),
                     albumin = list(fixed = albumin ~ time,
                                    random = ~ time),
                     alkaline = list(fixed = alkaline ~ time,
                                     random = ~ time))

# Build fixed data
fixedData_train <- unique(pbc2_train[,c("id","age","drug","sex")])

# Build outcome data
Y <- list(type = "surv",
          Y = unique(pbc2_train[,c("id","years","event")]))

# Run DynForest function
res_dyn <- DynForest(timeData = timeData_train, fixedData = fixedData_train,
                     timeVar = "time", idVar = "id",
                     timeVarModel = timeVarModel, Y = Y,
                     ntree = 50, nodesize = 5, minsplit = 5,
                     cause = 2, ncores = 2, seed = 1234)

# Compute OOB error
res_dyn_OOB <- compute_OOBerror(DynForest_obj = res_dyn, ncores = 2)

# Compute VIMP statistic
res_dyn_VIMP <- compute_VIMP(DynForest_obj = res_dyn_OOB)

# Plot VIMP
plot_VIMP(res_dyn_VIMP)

}
}
\seealso{
\code{\link{DynForest} \link{compute_VIMP} \link{compute_gVIMP} \link{plot_gVIMP} \link{plot_mindepth}}
}
