##########
# GENERICS
##########
#' Hidden methods
#'
#' @name DynTxRegime-internal-api
#' @keywords internal
#' @import methods
tmp <- function(x){}

#' Extract Model Coefficients From Objects Returned by Modeling Functions
#'
#' A list is returned, one element for each regression step required by
#'   the statistical method. 
#'
#' Methods are defined for all statistical methods implemented in DynTxRegime.
#'
#' The exact structure of the returned list will vary depending on
#'  the statistical method. 
#'  For methods that include a propensity regression, the returned list will 
#'  include an element named 'propen'. For methods that include an outcome 
#'  regression, the returned list will include an element named 'outcome'.
#'
#' @param object Value object returned by any statistical method implemented
#'   in DynTxRegime.
#' @param ... Optional additional inputs defined by coefficient methods of 
#'   selected regression functions.
#'
#' @name coef
#' @usage
#'
#'   coef(object, ...)
#'
NULL

#' Result Summaries
#'
#' Returns a list of the primary results, including regression results, 
#'   optimization results, estimated tx and value, etc.
#'
#' Methods are defined for all statistical methods implemented in DynTxRegime.
#'
#' The exact structure of the returned list will vary depending on
#'  the statistical method. 
#'
#' @param object Value object returned by a statistical method
#' @param ... Optional additional inputs
#'
#' @name summary
#' @usage
#'   summary(object, ...)
#'
NULL

#' Objects Returned by Modeling Functions
#'
#' Returns a list of the objects returned by all modeling functions
#'
#' Methods are defined for all statistical methods implemented in DynTxRegime.
#'
#' The exact structure of the returned list will vary depending on
#'  the statistical method. 
#'  For methods that include a propensity regression, the returned list will 
#'  include an element named 'propen'. For methods that include an outcome 
#'  regression, the returned list will include an element named 'outcome'.
#'
#' @param object Value object returned by a statistical method of DynTxRegime
#' @param ... Optional additional inputs
#'
#' @name fitObject
#' @usage
#' fitObject(object, ...)
#'
NULL

#' Generates Plots as Defined by Modeling Functions
#'
#' Calls plot() method for all regression steps of a statistical method
#'
#' Methods are defined for all statistical methods implemented in DynTxRegime.
#'
#' @param x Value object returned by a statistical method
#' @param y Ignored
#' @param suppress T/F indicating if titles should be concatenated with
#'   information indicating the specific regression step
#' @param ... Optional additional inputs
#'
#' @name plot
#' @importFrom modelObj plot
NULL

#' Extract Model Residuals
#'
#' Retrieve residuals from an interactive Q-Learning step.
#'
#' @param object A value object returned by iqLearnC() or iqLearnVar()
#' @param ... Ignored.
#'
#' @usage
#'
#' residuals(object, ...)
#'
#' @name residuals
#' @importFrom modelObj residuals
NULL

#' Adolescent BMI dataset (generated toy example)
#'
#' A dataset generated to mimic data from a two-stage randomized clinical trial 
#' that studied the effect of meal replacement shakes on adolescent obesity. 
#' The dataset contains the following covariates collected at the start of the 
#' first stage: "gender," "race," "parentBMI," and "baselineBMI." At the 
#' second-stage, "month4BMI" was collected. Variables "A1" and "A2" are the 
#' randomized treatments at stages one and two, and "month12BMI" is the primary 
#' outcome collected at the end of stage two. 
#'
#' @name bmiData
#' @docType data
#' @format A matrix with rows corresponding to patients.
#' @source Generated by Kristin A. Linn in R
#' @keywords dataset
NULL

#' Defining the moPropen Input Variable
#'
#' Several of the statistical methods implemented in package
#' \pkg{DynTxRegime} use propensity score modeling. 
#' This section details how this
#' input is to be defined.
#'
#' For input \code{moPropen}, the method specified to obtain predictions 
#' MUST return the prediction on the scale of the probability,
#' i.e., predictions must be in the range (0,1). In 
#' addition, \code{moPropen} differs from standard \code{"modelObj"} 
#' objects in that an additional element may be required in 
#' \code{predict.args}. Recall, \code{predict.args} is the list of control 
#' parameters passed to the prediction method. An additional control 
#' parameter, \code{propen.missing} can be included. \code{propen.missing} 
#' takes value "smallest" or "largest". It will be required if the 
#' prediction method returns predictions for only a subset of the 
#' treatment data; e.g., predict.glm(). \code{propen.missing} indicates if 
#' it is the smallest or the largest treatment value that is missing
#' from the returned predictions.
#' 
#' For example, fitting a binary treatment (A in \{0,1\}) using
#' \preformatted{
#'   moPropen <- buildModelObj(model = ~1,
#'                             solver.method = 'glm',
#'                             solver.args = list('family'='binomial'),
#'                             predict.method = 'predict.glm',
#'                             predict.args = list(type='response'))
#' }
#' returns only P(A=1). P(A=0) is "missing," and thus
#' \preformatted{
#'   moPropen <- buildModelObj(model = ~1,
#'                             solver.method = 'glm',
#'                             solver.args = list('family'='binomial'),
#'                             predict.method = 'predict.glm',
#'                             predict.args = list(type='response',
#'                                                 propen.missing = 'smallest'))
#' }
#' If the dimension of the value returned by the prediction method is 
#' less than the number of treatment options and no value is provided 
#' in \code{propen.missing}, it is assumed that the smallest valued treatment
#' option is missing. Here, 'smallest' indicates the lowest value 
#' integer if treatment is an integer, or the 'base' level if treatment 
#' is a factor.
#' 
#' @name moPropen
#' 
NULL 


#' Defining the iter Input Variable
#'
#' Several of the statistical methods implemented in package
#' \pkg{DynTxRegime} allow for an iterative algorithm
#' when completing an outcome regression. 
#' This section details how this
#' input is to be defined.
#' 
#'  Outcome regression models are specified by the main effects components 
#'  (\code{moMain}) and the contrasts component (\code{moCont}). 
#'  Assuming that the  
#'  treatment is denoted as binary A, the full regression model is:  
#'  moMain + A*moCont. There are two ways to fit this model: (i)  
#'  in the full model formulation (moMain + A*moCont) or (ii) each  
#'  component, \code{moMain} and \code{moCont}, is fit separately. 
#'  \code{iter} specifies  
#'  if (i) or (ii) should be used.
#'                  
#'
#'  \code{iter} >= 1 indicates that \code{moMain} and \code{moCont}
#'   are to be
#'  fit separately using an iterative algorithm. 
#'  \code{iter} is the maximum number of iterations.
#'  Assume Y = Ymain + Ycont;
#'  the iterative algorithm is as follows:
#'
#'                  (1) hat(Ycont) = 0;
#'
#'                  (2) Ymain = Y - hat(Ycont);
#'
#'                  (3) fit Ymain ~ moMain;
#'
#'                  (4) set Ycont = Y - hat(Ymain)
#'
#'                  (5) fit Ycont ~ A*moCont;
#'
#'                  (6) Repeat steps (2) - (5) until convergence or
#'                  a maximum of iter iterations. 
#'
#'  This choice allows the user to specify, for example,
#'  a linear main effects component and a non-linear
#'  contrasts component.
#'
#'  \code{iter} <= 0 indicates that the full model formulation is to be
#'  used. The components \code{moMain} and \code{moCont} will be 
#'  combined in the package and fit as a single object.
#'  Note that if \code{iter} <= 0, all non-model components of
#'  \code{moMain} and \code{moCont} must be identical. Specifically,
#'  the regression method and any non-default arguments
#'  should be identical. 
#'  By default, the specifications in \code{moMain} are used.
#'
#' @name iter
NULL


#' Defining the fSet Input Variable
#' 
#' Several of the statistical methods implemented in package
#' \pkg{DynTxRegime} allow for subset modeling or limiting
#' of feasible treatment options. This section details how this
#' input is to be defined.
#' 
#' In general, input \code{fSet} is used to define subsets of patients 
#' within an analysis. These subsets can be specified to (1) limit 
#' available treatments, (2) use different models for the propensity 
#' score and/or outcome regressions, and/or 
#' (3) use different decision function models for 
#' each subset of patients. The combination of inputs \code{moPropen},
#' \code{moMain}, \code{moCont}, \code{fSet}, and/or \code{regimes} 
#' determines which of these scenarios is 
#' being considered. We cover some common situations below.
#' 
#' 
#' Regardless of the purpose for specifying \code{fSet}, it must be a 
#' function that returns a list. There are two options for defining the 
#' function. Version 1 is that of the original \pkg{DynTxRegime} package. 
#' In this version, \code{fSet} defines the rules
#' for determining the subset of treatment options for an INDIVIDUAL.
#' The first element of the returned list is a character, which we term
#' the subset 'nickname.' This nickname is for bookkeeping purposes 
#' and is used to link models to subsets. The second element 
#' of the returned list is a vector 
#' of available treatment options for the subset. The formal arguments of 
#' the function must include (i) 'data' or (ii) individual covariate 
#' names as given by the column headers of \code{data}. An example using the 
#' covariate name input form is
#' 
#' \preformatted{
#' fSet <- function(a1) \{
#'   if (a1 > 1) \{
#'     subset <- list('subA',c(1,2))
#'   \} else \{
#'     subset <- list('subB',c(3,4) )
#'   \}
#'   return(subset)
#' \}}
#' This function indicates that if an individual has covariate a1 > 1, 
#' they are a member of subset 'subA' and their feasible
#' treatment options are \{1,2\}. If a1 <= 1, they are a member of subset
#' 'subB' and their feasible treatment options are \{3,4\}.
#' 
#' A more efficient implementation for \code{fSet} is now accepted. In
#' the second form, \code{fSet} defines the subset of treatment options
#' for the full DATASET. It is again a function with
#' formal arguments  (i) 'data' or (ii) individual covariate names as 
#' given by the column headers of \code{data}. The function returns a list 
#' containing two elements: 'subsets' and 'txOpts.'  Element 'subsets' is 
#' a list comprising all treatment subsets; each element of the list contains 
#' the nickname and treatment options for a single subset. Element
#' 'txOpts' is a character vector indicating the subset of which
#' each individual is a member. In this new format, 
#' the equivalent definition of \code{fSet} as that given above is:
#' 
#' \preformatted{
#' fSet <- function(a1) \{
#'   subsets <- list(list('subA', c(1,2)),
#'                   list('subB', c(3,4)))
#'   txOpts <- rep('subB', length(x = a1))
#'   txOpts[a1 > 1] <- 'subA'
#' 
#'   return(list("subsets" = subsets,
#'               "txOpts" = txOpts))
#' \}}
#' 
#' Though a bit more complicated, this version is much more efficient as
#' it processes the entire dataset at once rather than each individual 
#' separately.
#' 
#' The simplest scenario involving \code{fSet} is to define feasible 
#' treatment options and the rules that dictate how those treatment 
#' options are determined. For example, 
#' responder/non-responder scenarios are often encountered in
#' multiple-decision-point settings. An example of this scenario is:
#' patients that respond to the first stage treatment
#' remain on the original treatment; those that
#' do not respond to the first stage treatment
#' have all treatment options available to them at the second stage. 
#' In this case, the 
#' propensity score models for the second stage
#' are fit using only 'non-responders' for whom 
#' more than 1 treatment option is available. 
#' 
#' An example of an appropriate \code{fSet} function for
#' the second-stage is
#' \preformatted{ 
#' fSet <- function(data) \{ 
#'    if (data\$responder  == 0L) \{ 
#'      subset <- list('subA',c(1L,2L))
#'    \} else if (data\$tx1 == 1L) \{ 
#'      subset <- list('subB',c(1L) )
#'    \} else if (data\$tx1 == 2L) \{ 
#'      subset <- list('subC',c(2L) )
#'    \} 
#'    return(subset) 
#' \} }
#' for version 1 or for version 2
#' \preformatted{
#' fSet <- function(data) \{
#'   subsets <- list(list('subA', c(1L,2L)),
#'                   list('subB', c(1L)),
#'                   list('subC', c(2L)))
#'   txOpts <- character(nrow(x = data))
#'   txOpts[data$tx1 == 1L] <- 'subB'
#'   txOpts[data$tx1 == 2L] <- 'subC'
#'   txOpts[data$responder == 0L] <- 'subA'
#' 
#'   return(list("subsets" = subsets,
#'               "txOpts" = txOpts))
#' \}}
#' 
#' 
#' The functions above specify that patients with covariate responder = 0 
#' receive treatments from subset 'subA,' which comprises treatments 
#' A = (1,2). Patients with covariate responder = 1 receive treatment 
#' from subset 'subB' or 'subC' depending on the first stage treatment
#' received. If
#' \code{fSet} is specified in this way, the form of the model object depends
#' on the training data. Specifically, if the training data obeys the feasible
#' treatment rule (here, all individuals with responder = 1 received tx
#' in accordance with fSet), \code{moPropen} would be a \code{"modelObj"};
#' the propensity model will be fit using only those patients with 
#' responder = 0; those with responder = 1 always receive the appropriate
#' second stage treatment with probability 1.0. However, if the data
#' are from an observation study and the training data do not obey the
#' feasible treatment rules (here, some individuals with responder = 1 received 
#' tx = 0; others tx = 1), the responder = 1 data must be modeled and moPropen
#' must be provided as one or more ModelObjSubset() objects.
#'
#' If outcome regression is used by the method,
#' \code{moMain} and \code{moCont} can be either objects
#' of class \code{"modelObj"} if only responder = 0 patients are to be used
#' to obtain parameter estimates or as lists of objects of class 
#' \code{"ModelObjSubset"} if subsets are to be analyzed individually or
#' combined for a single fit of all data.
#' 
#' For a scenario where all patients have the same set of treatment
#' options available, but subsets of patients are to be analyzed using 
#' different models. We cane define \code{fSet} as
#' \preformatted{ 
#' fSet <- function(data) \{ 
#'    if (data\$a1 == 1) \{ 
#'      subset <- list('subA',c(1L,2L))
#'    \} else \{ 
#'      subset <- list('subB',c(1L,2L) )
#'    \} 
#'    return(subset) 
#' \} }
#' for version 1 or in the format of version 2
#' \preformatted{
#' fSet <- function(data)
#' \{
#'   subsets <- list(list('subA', c(1L,2L)),
#'                   list('subB', c(1L,2L)))
#'   txOpts <- rep('subB', nrow(x = data))
#'   txOpts[data$a1 == 1L] <- 'subA'
#' 
#'   return(list("subsets" = subsets,
#'               "txOpts" = txOpts))
#' \}}
#' 
#' where all patients have the same treatment options available, A = (1,2),
#' but different regression models will be fit for each subset (case 2 above) 
#' and/or different decision function models (case 3 above) for each
#' subset. If different propensity score models are used, \code{moPropen} 
#' must be a list of objects of class \code{"modelObjSubset."}
#' Perhaps,
#' \preformatted{ 
#'   propenA <- buildModelObjSubset(model = ~1,
#'                                  solver.method = 'glm',
#'                                  solver.args = list('family'='binomial'),
#'                                  predict.method = 'predict.glm',
#'                                  predict.args = list(type='response'),
#'                                  subset = 'subA')
#' 
#'   propenB <- buildModelObjSubset(model = ~1,
#'                                  solver.method = 'glm',
#'                                  solver.args = list('family'='binomial'),
#'                                  predict.method = 'predict.glm',
#'                                  predict.args = list(type='response'),
#'                                  subset = 'subB')
#' 
#'   moPropen <- list(propenA, propenB)
#'  }
#' If different decision function models are to be fit, \code{regimes}
#' would take a form similar to
#' \preformatted{ 
#'   regimes <- list( 'subA' = ~x1 + x2,
#'                    'subB' = ~x2 )
#' }
#' Notice that the names of the elements of \code{regimes} and the subsets passed to
#' buildModelObjSubset() correspond to the names defined by \code{fSet},
#' i.e., 'subA' or 'subB.' These nicknames are used for bookkeeping and 
#' link subsets to the appropriate models.
#' 
#' 
#' For a single-decision-point analysis, \code{fSet}
#' is a single function. For multiple-decision-point analyses,
#' \code{fSet} is a list of functions where each element of 
#' the list corresponds to the decision point (1st element <-
#' 1st decision point, etc.)
#' 
#' @name fSet
#'
NULL

