% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{gbm_pro}
\alias{gbm_pro}
\title{Train a Gradient Boosting Machine (GBM) for Survival Data}
\usage{
gbm_pro(X, y_surv, tune = FALSE, cv.folds = 3)
}
\arguments{
\item{X}{A data frame of features.}

\item{y_surv}{A \code{survival::Surv} object representing the survival outcome.}

\item{tune}{Logical, whether to perform simplified hyperparameter tuning.
If \code{TRUE}, \code{n.trees}, \code{interaction.depth}, and \code{shrinkage} are set to
predefined values suitable for tuning; otherwise, default values are used.}

\item{cv.folds}{Integer. The number of cross-validation folds to use.
Setting this to 0 or 1 will disable cross-validation. Defaults to 3.}
}
\value{
A list of class "train" containing the trained \code{gbm} model object,
names of features used in training, and model type. The returned object
also includes \code{fitted_scores} (linear predictor), \code{y_surv}, and \code{best_iter}.
}
\description{
Trains a Gradient Boosting Machine (GBM) model with a Cox
proportional hazards loss function using \code{gbm}.
}
\examples{
\donttest{
# Generate some dummy survival data
set.seed(42)
n_samples <- 200
n_features <- 5
X_data <- as.data.frame(matrix(rnorm(n_samples * n_features), ncol = n_features))
Y_surv_obj <- survival::Surv(
  time = runif(n_samples, 100, 1000),
  event = sample(0:1, n_samples, replace = TRUE)
)

# Train the model for the example *without* cross-validation to pass R CMD check
# In real use, you might use the default cv.folds = 3
gbm_model <- gbm_pro(X_data, Y_surv_obj, cv.folds = 0)
print(gbm_model$finalModel)
}
}
