% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{find_keyword}
\alias{find_keyword}
\title{Find a keyword}
\usage{
find_keyword(keyword, data = getOption("edc_lookup", NULL), ignore_case = TRUE)
}
\arguments{
\item{keyword}{the keyword to search for}

\item{data}{the dataframe where to search the keyword. Can be set using \code{options(edc_lookup=my_data)}, which is done automatically when calling \code{\link[=read_trialmaster]{read_trialmaster()}}.}

\item{ignore_case}{should case differences be ignored in the match?}
}
\value{
a filtered tibble
}
\description{
Find a keyword in all names and labels of a list of datasets.
}
\section{EDCimport}{

Usually,
}

\examples{
library(crosstable)
library(dplyr)
library(purrr)

#Using a custom table list
lookup = list(i=crosstable::iris2, m=crosstable::mtcars2) \%>\% get_lookup()
find_keyword("hp", data=lookup)
find_keyword("number|date", data=lookup)
find_keyword("number|date", data=lookup, ignore_case=FALSE)

#Using lookup from [read_trialmaster()]
\dontrun{
path = system.file("extdata/Example_Export_SAS_XPORT_2022_08_25_15_16.zip", 
                   package = "EDCimport", mustWork=TRUE)
w = read_trialmaster(path, verbose=FALSE)
options(edc_lookup=w$.lookup) #optional
find_keyword("patient")
}
}
