% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_all_sas.R
\name{read_all_sas}
\alias{read_all_sas}
\title{Read all \code{.sas7bdat} files in a directory}
\usage{
read_all_sas(
  path,
  ...,
  format_file = "procformat.sas",
  clean_names_fun = NULL,
  datetime_extraction = "guess",
  verbose = getOption("edc_read_verbose", 1)
)
}
\arguments{
\item{path}{[\code{character(1)}]\cr the path to the directory containing all \code{.sas7bdat} files.}

\item{...}{unused}

\item{format_file}{[\code{character(1)}]\cr the path to the file that should be used to apply formats. See details. Use \code{NULL} to not apply formats.}

\item{clean_names_fun}{[\code{function}]\cr a function to clean column names, e.g. \link{tolower}, \code{\link[janitor:clean_names]{janitor::clean_names()}},...}

\item{datetime_extraction}{[\code{POSIXt(1)}]\cr the datetime of the data extraction. Default to the most common date of last modification in \code{directory}.}

\item{verbose}{[\code{logical(1)}]\cr one of \code{c(0, 1, 2)}. The higher, the more information will be printed.}
}
\value{
a list containing one dataframe for each \code{.xpt} file in the folder, the extraction date (\code{datetime_extraction}), and a summary of all imported tables (\code{.lookup}).
}
\description{
Read all \code{.sas7bdat} files in a directory. Formats can be applied from a \code{procformat.sas} SAS file, from a .
}
\section{Format file}{

\code{format_file} should contain the information about SAS formats. It can be either
\itemize{
\item a \code{procformat.sas} file, containing the whole PROC FORMAT
\item a catalog file (\code{.sas7bcat})
\item or a data file (\code{.csv} or \code{.sas7bdat}) containing 3 columns: the SAS format name (repeated),
each level, and its associated label. Use \code{options(edc_var_format_name="xxx", edc_var_level="xxx", edc_var_label="xxx")} to specify the names of the columns.
}
}

