% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionStability.R
\name{dimensionStability}
\alias{dimensionStability}
\title{Dimension Stability Statistics from \code{\link[EGAnet]{bootEGA}}}
\usage{
dimensionStability(bootega.obj, ...)
}
\arguments{
\item{bootega.obj}{A \code{\link[EGAnet]{bootEGA}} object}

\item{...}{Additional arguments.
Used for deprecated arguments from previous versions of dimStability}
}
\value{
Returns a list containing:

\item{dimension.stability}{A list containing:

\itemize{

\item{\strong{\code{structural.consistency}}}
{The proportion of times that each empirical \code{\link[EGAnet]{EGA}} dimension
\emph{exactly} replicates across the \code{\link[EGAnet]{bootEGA}} samples}

\item{\strong{\code{average.item.stability}}}
{The average item stability in each empirical \code{\link[EGAnet]{EGA}} dimension}
  }
}

\item{item.stability}{Results from \code{\link[EGAnet]{itemStability}}}
}
\description{
Based on the \code{\link[EGAnet]{bootEGA}} results, this function
computes the stability of dimensions. This is computed by assessing the proportion of
times the original dimension is exactly replicated in across bootstrap samples
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{# Estimate EGA network
## plot.type = "qqraph" used for CRAN checks
## plot.type = "GGally" is the default
ega.wmt <- EGA(data = wmt, model = "glasso", plot.type = "qgraph")

# Estimate bootstrap EGA
boot.wmt <- bootEGA(data = wmt, iter = 500, typicalStructure = TRUE,
plot.typicalStructure = TRUE, model = "glasso", plot.type = "qgraph",
type = "parametric", ncores = 2)
}

# Estimate stability statistics
res <- dimensionStability(boot.wmt)
res$dimension.stability

# Changing plot features (ggplot2)
## Changing colors (ignore warnings)
### qgraph Defaults
res$item.stability$plot +
    ggplot2::scale_color_manual(values = rainbow(length(
    res$dimension.stability$structural.consistency)))

### Pastel
res$item.stability$plot +
    ggplot2::scale_color_brewer(palette = "Pastel1")

## Changing Legend (ignore warnings)
res$item.stability$plot +
    ggplot2::scale_color_discrete(labels = "Intelligence")

}
\references{
Christensen, A. P., & Golino, H. (2021).
Estimating the stability of the number of factors via Bootstrap Exploratory Graph Analysis: A tutorial.
\emph{Psych}, \emph{3}(3), 479-500.

Christensen, A. P., Golino, H., & Silvia, P. J. (2020).
A psychometric network perspective on the validity and validation of personality trait questionnaires.
\emph{European Journal of Personality}, \emph{34}(6), 1095-1108.
}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and
\code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
