% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDFM.R
\name{simDFM}
\alias{simDFM}
\title{Simulate data following a Dynamic Factor Model}
\usage{
simDFM(
  variab,
  timep,
  nfact,
  error,
  dfm = c("DAFS", "RandomWalk"),
  loadings,
  autoreg,
  crossreg,
  var.shock,
  cov.shock,
  burnin = 1000
)
}
\arguments{
\item{variab}{Number of variables per factor.}

\item{timep}{Number of time points.}

\item{nfact}{Number of factors.}

\item{error}{Value to be used to construct a diagonal matrix Q. This matrix is p x p covariance matrix Q that will
generate random errors following a multivariate normal distribution with mean zeros.
The value provided is squared before constructing Q.}

\item{dfm}{A string indicating the dynamical factor model to use.
Current options are:

\itemize{

\item{\strong{\code{DAFS}}}
{Simulates data using the direct autoregressive factor score model.
This is the default method}

\item{\strong{\code{RandomWalk}}}
{Simulates data using a dynamic factor model with random walk factor scores.}
}}

\item{loadings}{Magnitude of the loadings.}

\item{autoreg}{Magnitude of the autoregression coefficients.}

\item{crossreg}{Magnitude of the cross-regression coefficients.}

\item{var.shock}{Magnitude of the random shock variance.}

\item{cov.shock}{Magnitude of the random shock covariance}

\item{burnin}{Number of n first samples to discard when computing the factor scores. Defaults to 1000.}
}
\description{
Function to simulate data following a dynamic factor model (DFM). Two DFMs are currently available:
the direct autoregressive factor score model (Engle & Watson, 1981; Nesselroade, McArdle, Aggen, and Meyers, 2002) and the
dynamic factor model with random walk factor scores.
}
\examples{


\dontrun{
\donttest{
# Estimate EGA network
data1 <- simDFM(variab = 5, timep = 50, nfact = 3, error = 0.05,
dfm = "DAFS", loadings = 0.7, autoreg = 0.8,
crossreg = 0.1, var.shock = 0.18,
cov.shock = 0.36, burnin = 1000)
 }
}

}
\references{
Engle, R., & Watson, M. (1981).
A one-factor multivariate time series model of metropolitan wage rates.
\emph{Journal of the American Statistical Association}, \emph{76}(376), 774-781.

Nesselroade, J. R., McArdle, J. J., Aggen, S. H., & Meyers, J. M. (2002).
Dynamic factor analysis models for representing process in multivariate time-series. In D. S. Moskowitz & S. L. Hershberger (Eds.),
\emph{Multivariate applications book series. Modeling intraindividual variability with repeated measures data: Methods and applications}, 235-265.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
