% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simEGM.R
\name{simEGM}
\alias{simEGM}
\title{Simulate data following a Exploratory Graph Model (\code{\link[EGAnet]{EGM}})}
\usage{
simEGM(
  communities,
  variables,
  loadings,
  cross.loadings = 0.02,
  correlations,
  sample.size,
  max.iterations = 1000
)
}
\arguments{
\item{communities}{Numeric (length = 1).
Number of communities to generate}

\item{variables}{Numeric vector (length = 1 or \code{communities}).
Number of variables per community}

\item{loadings}{Numeric (length = 1).
Magnitude of the assigned network loadings.
For reference, small (0.20), moderate (0.35), and large (0.50)

Uses \code{runif(n, min = value - 0.075, max = value + 0.075)} for some jitter in the loadings}

\item{cross.loadings}{Numeric (length = 1).
Standard deviation of a normal distribution with a mean of zero (\code{n, mean = 0, sd = value}).
Defaults to \code{0.02}.
Not recommended to change too drastically (small increments such as \code{0.01} work best)}

\item{correlations}{Numeric (length = 1).
Magnitude of the community correlations}

\item{sample.size}{Numeric (length = 1).
Number of observations to generate}

\item{max.iterations}{Numeric (length = 1).
Number of iterations to attempt to get convergence before erroring out.
Defaults to \code{1000}}
}
\description{
Function to simulate data based on \code{\link[EGAnet]{EGM}}
}
\examples{
simulated <- simEGM(
  communities = 2, variables = 6,
  loadings = 0.55, # use standard factor loading sizes
  correlations = 0.30,
  sample.size = 1000
)

}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
