% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalAxis.R
\name{generalAxis}
\alias{generalAxis}
\title{Axis generation for log discharge}
\usage{
generalAxis(x, maxVal, minVal, units = NA, logScale = FALSE,
  tinyPlot = FALSE, padPercent = 5, concentration = TRUE, concLab = 1,
  usgsStyle = FALSE, prettyDate = TRUE)
}
\arguments{
\item{x}{vector to create scale about}

\item{maxVal}{number maximum value on returned scale}

\item{minVal}{number minimum value on returned scale}

\item{units}{character concentration units. Typically found in INFO$param.units.}

\item{logScale}{logical whether or not to return a log scale}

\item{tinyPlot}{logical}

\item{padPercent}{number used to pad the max and min if not specified}

\item{concentration}{logical if concentration=TRUE, labels returned as concentration units, otherwise flux units.}

\item{concLab}{object of concUnit class, or numeric represented the short code, 
or character representing the descriptive name. By default, this argument sets
concentration labels to use either Concentration or Conc (for tiny plots). Units
are taken from the eList$INFO$param.units. To use any other words than
"Concentration" see \code{vignette(topic = "units", package = "EGRET")}.}

\item{usgsStyle}{logical option to use USGS style guidelines. Setting this option
to TRUE does NOT guarantee USGS compliance. It will only change automatically
generated labels}

\item{prettyDate}{logical use 'pretty' limits for date axis if TRUE, or force the yearStart/yearEnd as limits if FALSE}
}
\description{
Discharge axis tick generation
}
\examples{
eList <- Choptank_eList
Daily <- getDaily(eList)
INFO <- getInfo(eList)
x <- Daily$Q
max <- max(x)
min <- 0
units <- INFO$param.units
generalAxis(x, max, min, units)
min <- min(x)
generalAxis(x, max, min, units, log=TRUE)
generalAxis(Daily$ConcDay, 100, 0, concLab = "concentration")
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}
