% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wBTCode.R
\name{wBT}
\alias{wBT}
\title{Run the WBT (WRTDS Bootstrap Test)}
\usage{
wBT(eList, caseSetUp, saveOutput = TRUE, fileName = "temp.txt")
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{caseSetUp}{data frame. Returned from \code{\link{trendSetUp}}.}

\item{saveOutput}{logical. If \code{TRUE}, a text file will be saved in the working directory.}

\item{fileName}{character. Name to save the output file if \code{saveOutput=TRUE}.}
}
\value{
eBoot, a named list with bootOut,wordsOut,xConc,xFlux values
}
\description{
Runs the WBT for a given data set to evaluate the significance level and
confidence intervals for the trends between two specified years.  The trends
evaluated are trends in flow normalized concentration and flow normalized flux.
Function produces text outputs and a named list (eBoot) that contains all of the
relevant outputs.
}
\examples{
library(EGRET)
eList <- Choptank_eList
\dontrun{
caseSetUp <- trendSetUp(eList)
eBoot <- wBT(eList,caseSetUp)
}
}
\seealso{
\code{\link{trendSetUp}}, \code{\link{setForBoot}}
}

