% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wBTCode.R
\name{wBT}
\alias{wBT}
\title{Run the WBT (WRTDS Bootstrap Test)}
\usage{
wBT(eList, caseSetUp, saveOutput = TRUE, fileName = "temp.txt",
  startSeed = 494817)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{caseSetUp}{data frame. Returned from \code{\link{trendSetUp}}.}

\item{saveOutput}{logical. If \code{TRUE}, a text file will be saved in the working directory.}

\item{fileName}{character. Name to save the output file if \code{saveOutput=TRUE}.}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}
}
\value{
eBoot, a named list with bootOut,wordsOut,xConc,xFlux values. bootOut is a data frame with the results
of the bootstrapping tests. wordsOut is a character vector describing the results.
xConc, xFlux are vectors of length iBoot, of the change in flow normalized concentration or flux 
computed by each bootstrap replicate (mg/L). pConc and pFlux are vectors of length iBoot, of the change 
in flow normalized concentration or flux computed from each bootstrap replicate expressed as % change.
}
\description{
Runs the WBT for a given data set to evaluate the significance level and 
confidence intervals for the trends between two specified years.  The trends 
evaluated are trends in flow normalized concentration and flow normalized flux.  
Function produces text outputs and a named list (eBoot) that contains all of the 
relevant outputs. Check out \code{\link{runPairsBoot}} and \code{\link{runGroupsBoot}}
for more bootstrapping options.
}
\examples{
library(EGRET)
eList <- Choptank_eList
\dontrun{
  caseSetUp <- trendSetUp(eList,
  year1=1985, 
  year2=2005,
  nBoot = 50, 
  bootBreak = 39,
  blockLength = 200)
eBoot <- wBT(eList,caseSetUp)
}
}
\seealso{
\code{\link{trendSetUp}}, \code{\link{setForBoot}}, \code{\link{runGroupsBoot}}, \code{\link{runPairsBoot}}
}
