% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\name{plotIGTProjection}
\alias{plotIGTProjection}
\alias{plotIGTProjection,IGTProjection-method}
\title{Information Geometric Temporal plot}
\usage{
plotIGTProjection(
  igtProjection,
  dimensions = 3,
  startDate = min(igtProjection@dataTemporalMap@dates),
  endDate = max(igtProjection@dataTemporalMap@dates),
  colorPalette = "Spectral",
  trajectory = FALSE
)

\S4method{plotIGTProjection}{IGTProjection}(
  igtProjection,
  dimensions = 3,
  startDate = min(igtProjection@dataTemporalMap@dates),
  endDate = max(igtProjection@dataTemporalMap@dates),
  colorPalette = "Spectral",
  trajectory = FALSE
)
}
\arguments{
\item{igtProjection}{of class \code{IGTProjection}}

\item{dimensions}{number of dimensions of the plot, 2 or 3 (3 by default)}

\item{startDate}{a Date object indicating the first date to be displayed in the IGT plot. 
By default the first date of the \code{IGTProjection} object.}

\item{endDate}{a Date object indicating the last date to be displayed in the IGT plot 
By default the last date of the \code{IGTProjection} object.}

\item{colorPalette}{color palette to be used. The default "Spectral" palette shows a color temperature 
scheme from blue, through yellow, to red (see "Spectral" palette in RColorBrewer package). 
The four remaining options are better suited for those with colorblindness, including "Viridis", 
"Magma", and their reversed versions "Viridis-reversed" and "Magma-reversed" (see "Viridis" and 
"Magma" palettes in the Viridis package).}

\item{trajectory}{whether to show an estimated trajectory of the information evolution over time. 
By default \code{FALSE}.}
}
\value{
A plot object based on the \code{plotly} package.
}
\description{
Plots an interactive Information Geometric Temporal (IGT) plot from an \code{IGTProjection} object.
An IGT plot visualizes the variability among time batches in a data repository in a 2D or 3D plot.
Time batches are positioned as points where the distance between them represents the probabilistic 
distance between their distributions (currently Jensen-Shannon distance, more distances will be 
supported in the future).
To track the temporal evolution, temporal batches are labeled to show their date and 
colored according to their season or period, according to the analysis period, as follows.
If period=="year" the label is "yy" (2 digit year) and the color is according to year.
If period=="month" the label is "yym" (yy + abbreviated month*) and the color is according 
to the season (yearly).
If period=="week" the label is "yymmw" (yym + ISO week number in 1-2 digit) and the color is 
according to the season (yearly). An estimated smoothed trajectory of the information evolution
over time can be shown using the optional "trajectory" parameter.
*Month abbreviations: \{'J', 'F', 'M', 'A', 'm', 'j', 'x', 'a', 'S', 'O', 'N', 'D'\}.
}
\details{
Note that since the projection is based on multidimensional scaling, a 2 dimensional 
projection entails a loss of information compared to a 3 dimensional projection. E.g., periodic 
variability components such as seasonal effect can be hindered by an abrupt change or a general trend.
}
\examples{
load(system.file("extdata",
                 "variabilityDemoNHDSdiagcode1-phewascode.RData",
                  package="EHRtemporalVariability"))

p <- plotIGTProjection( igtProjection   =  igtProjs[[1]],
                        colorPalette    = "Spectral",
                        dimensions      = 2)
p

\dontrun{

# For additional and larger examples download the following .Rdata file:

gitHubUrl  <- 'http://github.com/'
gitHubPath <- 'hms-dbmi/EHRtemporalVariability-DataExamples/'
gitHubFile <- 'raw/master/variabilityDemoNHDS.RData'
inputFile  <-  paste0(gitHubUrl, gitHubPath, gitHubFile)

load(url(inputFile)) 
plotIGTProjection(igtProjs$`diagcode1-phewascode`, dimensions = 3)
} 
}
