% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{IGTProjection-class}
\alias{IGTProjection-class}
\alias{IGTProjection}
\alias{IGTProjection,IGTProjection-class}
\title{Class IGTProjection}
\value{
A \code{IGTProjection} object.
}
\description{
Class \code{IGTProjection} object contains the estimated Information Geometric Temporal plot projection
of a \code{DataTemporalMap} object.
}
\details{
Objects of this class are generated automatically by the \code{estimateIGTProjection} function, and can
be passed to the \code{plotIGTProjection} function for plotting the Information Geometric Temporal plot.
}
\section{Slots}{

\describe{
\item{\code{dataTemporalMap}}{the \code{DataTemporalMap} object from which the projection was estimated}

\item{\code{projection}}{d-by-c \code{matrix} of the IGT projection for d temporal batches in c dimensions calculated from the \code{estimateIGTProjection} function}

\item{\code{embeddingType}}{embedding function used for the IGT projection calculation in the \code{estimateIGTProjection} function}

\item{\code{stress}}{stress achieved in the lower-dimensional embedding, depending on the embedding type (e.g., classicalmds will return 1-GOF as returned by stats::cmdscale function, and nonmetricmds will return final stress in percent, as returned by the MASS::isoMDS function)}
}}

