% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_LBA.R
\name{LBA}
\alias{LBA}
\title{The Linear Ballistic Accumulator model}
\usage{
LBA()
}
\value{
A model list with all the necessary functions for EMC2 to sample
}
\description{
Model file to estimate the Linear Ballistic Accumulator (LBA) in EMC2.
}
\details{
Model files are almost exclusively used in \code{design()}.

Default values are used for all parameters that are not explicitly listed in the \code{formula}
argument of \code{design()}.They can also be accessed with \code{LBA()$p_types}.\tabular{llllll}{
   \strong{Parameter} \tab \strong{Transform} \tab \strong{Natural scale} \tab \strong{Default} \tab \strong{Mapping} \tab \strong{Interpretation} \cr
   \emph{v} \tab - \tab [-Inf, Inf] \tab 1 \tab  \tab Mean evidence-accumulation rate \cr
   \emph{A} \tab log \tab [0, Inf] \tab log(0) \tab  \tab Between-trial variation (range) in start point \cr
   \emph{B} \tab log \tab [0, Inf] \tab log(1) \tab \emph{b} = \emph{B}+\emph{A} \tab Distance from \emph{A} to \emph{b} (response threshold) \cr
   \emph{t0} \tab log \tab [0, Inf] \tab log(0) \tab  \tab Non-decision time \cr
   \emph{sv} \tab log \tab [0, Inf] \tab log(1) \tab  \tab Between-trial variation in evidence-accumulation rate \cr
}


All parameters are estimated on the log scale, except for the drift rate which is estimated on the real line.

Conventionally, \code{sv} is fixed to 1 to satisfy scaling constraints.

The \emph{b} = \emph{B} + \emph{A} parameterization ensures that the response threshold is always higher than the between trial variation in start point of the drift rate.

Because the LBA is a race model, it has one accumulator per response option.
EMC2 automatically constructs a factor representing the accumulators \code{lR} (i.e., the
latent response) with level names taken from the \code{R} column in the data.

The \code{lR} factor is mainly used to allow for response bias, analogous to \code{Z} in the
DDM. For example, in the LBA, response thresholds are determined by the \emph{B}
parameters, so \code{B~lR} allows for different thresholds for the accumulator
corresponding to left and right stimuli (e.g., a bias to respond left occurs
if the left threshold is less than the right threshold).
For race models, the \code{design()} argument \code{matchfun} can be provided, a
function that takes the \code{lR} factor (defined in the augmented data (d)
in the following function) and returns a logical defining the correct response.
In the example below, the match is simply such that the \code{S} factor equals the
latent response factor: \code{matchfun=function(d)d$S==d$lR}. Then \code{matchfun} is
used to automatically create a latent match (\code{lM}) factor with
levels \code{FALSE} (i.e., the stimulus does not match the accumulator) and \code{TRUE}
(i.e., the stimulus does match the accumulator). This is added internally
and can also be used in model formula, typically for parameters related to
the rate of accumulation.

Brown, S. D., & Heathcote, A. (2008). The simplest complete model of choice response time: Linear ballistic accumulation.
\emph{Cognitive Psychology, 57}(3), 153-178. https://doi.org/10.1016/j.cogpsych.2007.12.002
}
\examples{
# When working with lM it is useful to design  an "average and difference"
# contrast matrix, which for binary responses has a simple canonical from:
ADmat <- matrix(c(-1/2,1/2),ncol=1,dimnames=list(NULL,"d"))
# We also define a match function for lM
matchfun=function(d)d$S==d$lR
# We now construct our design, with v ~ lM and the contrast for lM the ADmat.
design_LBABE <- design(data = forstmann,model=LBA,matchfun=matchfun,
                       formula=list(v~lM,sv~lM,B~E+lR,A~1,t0~1),
                       contrasts=list(v=list(lM=ADmat)),constants=c(sv=log(1)))
# For all parameters that are not defined in the formula, default values are assumed
# (see Table above).
}
