% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.l.R
\name{test.l}
\alias{test.l}
\title{Test a vector of weight transformation limits for mximum value.}
\usage{
test.l(X, l, ...)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{l}{\code{Numeric} vector, weight transformation limit, i.e.
quantile; default is 0.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
\code{List} with objects \item{step}{Numeric scalar with position 
of the last valid value.} \item{l.max}{Numeric scalar with last valid 
value of \code{l}.}
}
\description{
This function performs the weight transformation of the data matrix after
Klovan & Imbrie (1971) and performs EMMA() with different weight limits to
check if valied results are yielded. It returns the maximum value for which
the transformation remains stable.
}
\examples{

## load example data set
data(example_X)

test <- test.l(X = X, l = seq(from = 0, to = 0.6, by = 0.1))


}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180. \cr
Klovan JE, Imbrie J. 1971. An Algorithm and FORTRAN-IV Program for
Large-Scale Q-Mode Factor Analysis and Calculation of Factor Scores.
Mathematical Geology 3: 61-77.
}
\seealso{
\code{\link{EMMA}}, \code{\link{check.data}},
\code{\link{test.parameters}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
