% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.species.R
\name{drop.species}
\alias{drop.species}
\title{Takes a an ENMTools clade object and a vector of species names.  Drops the species from the tree and removes data from the clade object.}
\usage{
drop.species(clade, species)
}
\arguments{
\item{clade}{An ENMTools clade object}

\item{species}{A name or vector of names of species within the enmtools.clade object.}
}
\value{
An enmtools.clade object with the provided species dropped both from the tree and from the set of enmtools.species objects.
}
\description{
Takes a an ENMTools clade object and a vector of species names.  Drops the species from the tree and removes data from the clade object.
}
\examples{
\donttest{
data(iberolacerta.clade)
if(requireNamespace("ape", quietly = TRUE)) {
    new.clade <- drop.species(iberolacerta.clade, c("cyreni", "monticola"))
}
}
}
