% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/auxiliar.R
\name{aue.idig}
\alias{aue.idig}
\title{Increasing the number of alleles coding digits in a G data frame, for diploid
or haploid data}
\usage{
aue.idig(data, nin = 1, nout = 3, null = FALSE)
}
\arguments{
\item{data}{genetic data frame}

\item{nin}{Number of digits coding each allele in the input file}

\item{nout}{Number of digits in the output}

\item{null}{The missing data is representing null alleles? If TRUE,
the loci with missing data will be recoded as having
a null allele. Default FALSE.}
}
\description{
Increasing the number of alleles coding digits in a G data frame, for diploid
or haploid data
}
\details{
This function creates a data frame increasing the number of
digits in the input data. It can also convert missing data (coded as "0"
in the input) into a null allele. Null alleles will be coded as a chain of
 "9", matching the the number of digits required for the output.
}
\examples{
\dontrun{

data(eco3)
# null alleles present
recoded <- aue.idig(eco3$G, nin = 1, nout = 3, null = FALSE)
recoded

# null alleles absent
recoded <- aue.idig(eco3$G, nin = 1, nout = 3, null = TRUE)
recoded

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

