% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.3OF6.basic.methods.R
\docType{methods}
\name{eco.lock,ecogen-method}
\alias{eco.lock,ecogen-method}
\alias{eco.lock,ecogen}
\title{Lock rows in an ecogen object}
\usage{
\S4method{eco.lock}{ecogen}(object, set.names = NULL, valid.names = FALSE,
  order.df = FALSE)
}
\arguments{
\item{object}{object of class ecogen}

\item{set.names}{Character vector with names for the rows of the non-empty data frames. 
This argument is incompatible with valid.names}

\item{valid.names}{Logical. Create valid row names? This argument is incompatible with 
set.names. The program will name individuals with valid tags I.1, I.2, etc.}

\item{order.df}{Order individuals of data frames by row? (all data frames with a same order in row names).
 This option is only available when the 'lock.rows' parameter is TRUE. 
If the names of the data frames are not used (i.e., set.names and valid.names are not NULL),
setting this parameter to TRUE/FALSE has no effect in the function. 
Defalut TRUE. If FALSE, the row names of all the data frames must be ordered. The use of data frames 
with row names in different order will return an error.
In both cases, the program sets an internal names attribute of the object
using the row names of the first non-empty data frame found in the following order: 
XY, P, G, E, S, C. This attribute is used as reference to order rows when order.df = TRUE.}
}
\description{
This methods locks the rows in an ecogen object.  When rows are locked,
the object requires rows with identical indviduals in the non empty data frames, and
identity in the row names of the data frames.
}
\examples{
\dontrun{
data(eco.test)
eco2 <- eco.unlock(eco)
is.locked(eco2) 
eco3 <- eco.lock(eco2)
is.locked(eco3) 
}
}
