% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.merge.R
\name{eco.merge}
\alias{eco.merge}
\title{Merging two ecogen objects. Ordering the rows of an ecogen 
object according to the rows of another}
\usage{
eco.merge(e1, e2, ...)
}
\arguments{
\item{e1}{Object of class "ecogen".}

\item{e2}{Object of class "ecogen".}

\item{...}{Data frames to merge. Could be any combination of
the following: "XY",P","G","E" and "C", or "ALL". If a "G" data frame
is provided, the program generates also the INT slot by coding the missing
data as "0".}
}
\description{
Merging two ecogen objects. Ordering the rows of an ecogen 
object according to the rows of another
}
\details{
This program generates an ecogen object by binding the columns 
of the individuals that have matching row names in the objects e1 and e2. 
If the objects have different number of rows, the result is a merged data frame with 
the rows in the order of the first object.
If the objects have the same number of rows, but in a different order,
the product is an object with the rows ordered as the first object.
The algorithm matches sequentially the data frame pairs of each slot
that the user wishes to merge.
}
\examples{
\dontrun{
data(eco.test)
eco
eco1 <- eco[2:20]
merged <- eco.merge(eco, eco1)
merged
}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
