% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.6OF6.converters.R
\name{ecogen2geneland}
\alias{ecogen2geneland}
\title{Creating input data for Geneland with an ecogen object}
\usage{
ecogen2geneland(eco, dir = "", ncod = NULL, ploidy = 2)
}
\arguments{
\item{eco}{Object of class "ecogen"}

\item{dir}{output path. Default = "" (current directory).}

\item{ncod}{Number of digits coding each allele
(e.g., 1: x, 2: xx, 3: xxx, etc.).}

\item{ploidy}{Ploidy of the data.}
}
\value{
XY.txt Matrix with coordinates.

NAMES.txt Matrix with row names.

P.txt Matrix with phenotypic data.

G.txt Matrix with genotypic data.
}
\description{
This function creates four data frames (XY.txt, NAMES.txt, P.txt, G.txt) 
in the indicated directory (default: working directory), which can be loadedin Geneland.
}
\examples{

\dontrun{

data(eco.test)
ecogen2geneland(eco, dir = "", ncod=1)

}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

