\name{create.ETdiagnosis}
\alias{create.ETdiagnosis}
\title{
ET-Diagnosis
}
\description{
ET-Transpose provides a picture of an ecosystem under a given fishing mortality. ET-Diagnosis is a routine simulating how this baseline ecosystem would be impacted by increasing or decreasing fishing effort. Fishing effort can be modified per fleet and/or trophic group. Ecosystem-wide effects of altering fishing effort include potential changes in biomass, accessible biomass, production, kinetics and catch trophic spectra, as well as impacts on the mean trophic level of the catch and biomass. Additionally, ET-Diagnosis constitutes a useful exploratory tool for ecosystem-based management. It simulates how reducing or increasing fishing effort and/or preferentially targeting different trophic levels could improve yield at the ecosystem scale. Lastly, ET-Diagnosis allows to view how different assumptions on ecosystem functioning (biomass input control, top-down effect) affect both trophic level specific and ecosystem-wide properties in relation to fishing.
}
\usage{
create.ETdiagnosis(data, Mul_eff = NULL, Group = NULL, 
	fleet.of.interest = NULL, same.mE = NULL, B.Input=NULL, 
	Beta = NULL, TopD = NULL, FormD = NULL, TLpred = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
is the list object returned by the create.ETmain function. 
}
  \item{Mul_eff}{
is a vector of fishing effort multipliers that the user wants to test. Mul_eff must contain the value 1 (reference state). By default, the function simulates a range of fishing effort multipliers from 0 to 5 for each fleet.
}
  \item{Group}{
is a character vector of trophic groups that the user specifically wants to impact by changing associated fishing efforts. By default, all trophic groups are equally impacted.
}
  \item{fleet.of.interest}{
is a character vector of fleet(s) that the user specifically wants to impact by changing associated fishing efforts (default =NULL). This argument is of particular interest if there are more than two fleets because it limits the mE combinations to be tested, and thus the associated computation time.
}
  \item{same.mE}{
is a logical argument (default=F), if TRUE the same effort multipliers are simultaneously applied to all fleets.
}
  \item{B.Input}{
is a logical argument (default=F), if TRUE the "Biomass input control" equation is accounted for in EcoTroph equations.
}
  \item{Beta}{
is a coefficient expressing the extent of the biomass input control. Beta=0 refers to an ecosystem where all secondary production originates from grazing on primary producers, and Beta=1 to an ecosystem where detritus and/or recruitment contribute to a major part of the biomass input (default=0.2).
}
  \item{TopD}{
is a coefficient expressing the top-down control, i.e. the fraction of the natural mortality depending on predator abundance. It varies between 0 and 1. The user can specify a numeric value, which is applied to each trophic level, or a numeric vector (of the same length as TL classes), i.e. a value for each TL (default=0.4).
}
  \item{FormD}{
is a shape parameter varying between 0 and 1. It defines the functional relationship between prey and predators. The value 1 refers to a situation where predators abundance has a linear effect on the speed of the flow of their preys. The user can specify a numeric value, which is applied to each trophic level, or a numeric vector (of the same length as TL classes), i.e. a value for each TL (default=0.5).
}
  \item{TLpred}{
is the trophic level that the user considers to be the "predator" trophic classes start. The default value is 3.5.
}
}
\details{
Fleets' names used in the argument 'fleet.of.interest' are the catch column names of the Ecopath input data.frame (e.g. 'catch.1' or 'catch.ind').
}

\value{
This function returns a list of elements referring to each simulated combination of fishing effort multipliers. Each element is a list of two types of results:
-	Variables characterizing the state and functioning of the modeled ecosystem: biomass, flow, kinetic, catches (total and per fleet) and fishing mortality per trophic level.
-	Summary statistics (contained in the ET_Main_diagnose): absolute and relative (in comparison with the reference state) total biomass, flow, catches.
}
\author{
Colleter Mathieu, Guitton Jerome and Gatti Paul.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
plot.ETdiagnosis and plot.ETdiagnosis_isopleth to plot the principle graphics resulting from the create.ETdiagnosis function, create.ETmain to create a list of tables used as input in the create.ETdiagnosis function.
}
\examples{
data(ecopath_guinee)
#Impacts of global changes in fishing efforts multipliers (in the range 0-5)
create.ETdiagnosis(create.ETmain(ecopath_guinee),same.mE=TRUE) 
#Test of all the combinations of fishing effort multipliers per fleet 
#(in the range 0-5)
\donttest{create.ETdiagnosis(create.ETmain(ecopath_guinee))}
#With biomass input control
\donttest{create.ETdiagnosis(create.ETmain(ecopath_guinee),B.Input=TRUE)}
#Impacts of changing fishing effort against Barracudas+ and Carangids groups
\donttest{
create.ETdiagnosis(create.ETmain(ecopath_guinee),
	Mul_eff=(seq(0,5,.1)),Group=c('Barracudas+','Carangids'))
	}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~EcoTroph }
\keyword{ ~Diagnosis }
