% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTALIS.R
\name{downloadTALIS}
\alias{downloadTALIS}
\title{Download and Unzip TALIS Files}
\usage{
downloadTALIS(root, years = c(2008, 2013, 2018), cache = FALSE, verbose = TRUE)
}
\arguments{
\item{root}{a character string indicating the directory where the TALIS
data should be stored. Files are placed in a
subdirectory named TALIS/[year].}

\item{years}{a numeric value indicating the assessment year. Available years are 2008, 2013, and 2018.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download TALIS data.
             Data come from \href{https://www.oecd.org/education/talis/}{OECD TALIS site} international zip files. This
             function works for 2008, 2013,and 2018 data.
}
\examples{
\dontrun{
# root argument will vary by operating system conventions
downloadTALIS(root = "~/", years = 2018)
  
# cache=TRUE will download then process the datafiles
downloadTALIS(root = "~/", years = 2015, cache = TRUE)
  
# set verbose=FALSE for silent output
# if year not specified, download all years
downloadTALIS(root="~/", verbose = FALSE)
}
}
\seealso{
\code{\link{readTALIS}}
}
\author{
Tom Fink and Trang Nguyen
}
