% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllCopSim.R
\name{EllCopSim}
\alias{EllCopSim}
\title{Simulation from an elliptical copula model}
\usage{
EllCopSim(n, d, grid, g_d, A = diag(d), genR = list(method = "pinv"))
}
\arguments{
\item{n}{number of observations.}

\item{d}{dimension of X.}

\item{grid}{grid on which values of density generator are known.}

\item{g_d}{vector of values of the density generator on the \code{grid}.}

\item{A}{square-root of the correlation matrix of X.}

\item{genR}{additional arguments for the generation of the squared radius.
It must be a list with a component method: \itemize{
\item If \code{genR$method == "pinv"}, the radius is generated
using the function \code{\link[Runuran:pinv.new]{Runuran::pinv.new()}}.
\item If \code{genR$method == "MH"},
the generation is done using the Metropolis-Hasting algorithm,
with a N(0,1) move at each step.
}}
}
\value{
a matrix of size \verb{(n,d)} with \code{n} observations
of the \code{d}-dimensional elliptical copula.
}
\description{
Simulation from an elliptical copula model
}
\examples{
# Simulation from a Gaussian copula
grid = seq(0,5,by = 0.01)
X = EllCopSim(n = 20, d = 2, grid = grid, g_d = exp(-grid/2))
X = EllCopSim(n = 20, d = 2, grid = grid, g_d = exp(-grid/2),
              genR = list(method = "MH", niter = 500) )
plot(X)

}
\references{
Derumigny, A., & Fermanian, J. D. (2022).
Identifiability and estimation of meta-elliptical copula generators.
Journal of Multivariate Analysis, article 104962.
\doi{10.1016/j.jmva.2022.104962}.
}
\seealso{
\code{\link{EllDistrSim}} for the simulation of elliptical distributions samples,
\code{\link{EllCopEst}} for the estimation of elliptical copula,
\code{\link{EllCopLikelihood}} for the computation of the likelihood of a given generator,
\code{\link{DensityGenerator.normalize}} to compute the normalized version of a given generator.
}
