\name{ratings}
\alias{ratings}
\title{indiviual stimulus ratings}
\description{
get stimulus ratings and/or a summary plot
}
\usage{
ratings(x, show="mean", drawplot=TRUE)
}
\arguments{
  \item{x}{ an object of class \code{"elochoice"}, usually the result of a call to \code{\link{elochoice}}}
  \item{show}{character, what values should be returned, see below}
  \item{drawplot}{logical, should a plot drawn}
}
\details{
If \code{show="original"}, \code{show="mean"} or \code{show="var"}, a numeric vector is returned which contains either the ratings obtained from the initial/original sequence, the average ratings across all randomizations, or the total variance.

If \code{show="range"} or \code{show="all"}, a matrix is returned that contains either the range of ratings across all randomizations, or all ratings of all randomizations.

If you simply want to create the plot without any rating output being generated, use \code{show=NULL}.

If \code{drawplot=TRUE}, a plot is created that depicts the values of the ratings obtained from the initial sequence (red), the mean ratings across all randomizations (black) and the range of ratings across all randomizations.
}
\value{
numeric vector or matrix, and/or a plot
}
\author{Christof Neumann}
\examples{
xdata <- randompairs(nstim=10, nint=100)
x <- elochoice(xdata$winner, xdata$loser, runs=10)
# ratings from the initial sequence
ratings(x, "original", drawplot=FALSE)
# range of ratings across all randomizations
ratings(x, "range", drawplot=FALSE)
# and producing plot
ratings(x, NULL, drawplot=TRUE)
}

