% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.R
\name{SOM}
\alias{SOM}
\title{Build a self-organizing map}
\usage{
SOM(data, xdim = 10, ydim = 10, zdim = NULL, batch = F,
  rlen = 10, alphaA = c(0.05, 0.01),
  radiusA = stats::quantile(nhbrdist, 0.67) * c(1, 0), alphaB = alphaA
  * c(-negAlpha, -0.1 * negAlpha), radiusB = negRadius * radiusA,
  negRadius = 1.33, negAlpha = 0.1, epochRadii = seq(radiusA[1],
  radiusA[2], length.out = rlen), init = FALSE, initf = Initialize_PCA,
  distf = 2, codes = NULL, importance = NULL, coordsFn = NULL,
  nhbr.method = "maximum", noMapping = F, parallel = F,
  threads = if (parallel) 0 else 1)
}
\arguments{
\item{data}{Matrix containing the training data}

\item{xdim}{Width of the grid}

\item{ydim}{Hight of the grid}

\item{zdim}{Depth of the grid, causes the grid to be 3D if set}

\item{batch}{Use batch training (default \code{FALSE} chooses online training, which is more like FlowSOM)}

\item{rlen}{Number of training epochs; or number of times to loop over the training data in online training}

\item{alphaA}{Start and end learning rate for online learning (only for online training)}

\item{radiusA}{Start and end radius}

\item{alphaB}{Start and end learning rate for the second radius (only for online training)}

\item{radiusB}{Start and end radius (only for online training; make sure it is larger than radiusA)}

\item{negRadius}{easy way to set radiusB as a multiple of default radius
(use lower value for higher dimensions)}

\item{negAlpha}{the same for alphaB}

\item{epochRadii}{Vector of length \code{rlen} with precise epoch radii (only for batch training)}

\item{init}{Initialize cluster centers in a non-random way}

\item{initf}{Use the given initialization function if init==T
(default: Initialize_PCA)}

\item{distf}{Distance function (1=manhattan, 2=euclidean, 3=chebyshev, 4=cosine)}

\item{codes}{Cluster centers to start with}

\item{importance}{array with numeric values. Columns of \code{data} will be scaled according to importance.}

\item{coordsFn}{Function to generate/transform grid coordinates (e.g. \code{\link[=tSNECoords]{tSNECoords()}}). If \code{NULL} (default), the grid is the canonical SOM grid.}

\item{nhbr.method}{Way of computing grid distances, passed as \code{method=} to \code{\link[stats:dist]{stats::dist()}} function. Defaults to \code{maximum} (square neighborhoods); use \code{euclidean} for round neighborhoods.}

\item{noMapping}{If TRUE, do not compute the mapping (default FALSE). Makes the process quicker by 1 \code{rlen}.}

\item{parallel}{Parallelize the batch training by setting appropriate \code{threads}. Defaults to FALSE. Always use \code{batch=TRUE} for fully parallelized version, online training is not parallelizable. Passed to \code{\link[=MapDataToCodes]{MapDataToCodes()}}.}

\item{threads}{Number of threads of the batch training (has no effect on online training). Defaults to 0 (chooses maximum available hardware threads) if \code{parallel==TRUE} or 1 (single thread) if \code{parallel==FALSE}. Passed to \code{\link[=MapDataToCodes]{MapDataToCodes()}}.}
}
\value{
A map useful for embedding (\code{\link[=EmbedSOM]{EmbedSOM()}} function) or further analysis, e.g. clustering.
}
\description{
Build a self-organizing map
}
\seealso{
FlowSOM::SOM
}
