% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_epinow.R
\name{regional_epinow}
\alias{regional_epinow}
\title{Real-time Rt Estimation, Forecasting and Reporting by Region}
\usage{
regional_epinow(
  reported_cases,
  target_folder = NULL,
  target_date,
  non_zero_points = 2,
  output = c("regions", "summary", "samples", "plots", "latest"),
  return_output = FALSE,
  summary_args = list(),
  logs = tempdir(),
  ...
)
}
\arguments{
\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date), and region (\code{region}).}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not specified.}

\item{non_zero_points}{Numeric, the minimum number of time points with non-zero cases in a region required for
that region to be evaluated. Defaults to 2.}

\item{output}{A character vector of optional output to return. Supported options are the individual regional estimates
("regions"),  samples ("samples"), plots ("plots"), copying the individual region dated folder into
a latest folder (if \code{target_folder} is not null - set using "latest"), the stan fit of the underlying model ("fit"), and an
overall summary across regions ("summary"). The default is to return samples and plots alongside summarised estimates and
summary statistics. If \code{target_folder} is not NULL then the default is also to copy all results into a latest folder.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned, this automatically updates to TRUE
if no directory for saving is specified.}

\item{summary_args}{A list of arguments passed to \code{regional_summary}. See the \code{regional_summary} documentation for details.}

\item{logs}{Character path indicating the target folder in which to store log
information. Defaults to the temporary directory if not specified. Default logging
can be disabled if \code{logs} is set to NULL. If specifying a custom logging setup then
the code for \code{setup_default_logging} and the \code{setup_logging} function are a sensible
place to start.}

\item{...}{Pass additional arguments to \code{epinow}. See the documentation for \code{epinow} for details.}
}
\value{
A list of output stratified at the top level into regional output and across region output summary output
}
\description{
Estimates Rt by region. See the documentation for \code{epinow} for further information. The progress of producing
estimates across multiple regions is tracked using the \code{progressr} package. Modify this behaviour using progressr::handlers
and enable it in batch by setting \code{R_PROGRESSR_ENABLE=TRUE} as an environment variable.
}
\examples{
 \donttest{
# construct example distributions
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- list(mean = log(10), mean_sd = log(2),
                        sd = log(2), sd_sd = log(1.1), max = 30)
                        
# uses example case vector
cases <- EpiNow2::example_confirmed[1:40]
cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]))
                
# run epinow across multiple regions and generate summaries
# samples and warmup have been reduced for this example
out <- regional_epinow(reported_cases = cases, 
                       samples = 100,
                       generation_time = generation_time,
                       delays = list(incubation_period, reporting_delay),
                       stan_args = list(warmup = 100, 
                                        cores = ifelse(interactive(), 4, 1)))
}
}
