% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_secondary.R
\name{update_secondary_args}
\alias{update_secondary_args}
\title{Update estimate_secondary default priors}
\usage{
update_secondary_args(data, priors, verbose = TRUE)
}
\arguments{
\item{data}{A list of data and arguments as returned by \code{create_stan_data()}.}

\item{priors}{A \verb{<data.frame>} of named priors to be used in model fitting
rather than the defaults supplied from other arguments. This is typically
useful if wanting to inform a estimate from the posterior of another model
fit. Priors that are currently use to update the defaults are the scaling
fraction ("frac_obs"), and delay parameters ("delay_params"). The
\verb{<data.frame>} should have the following variables: \code{variable}, \code{mean}, and
\code{sd}.}

\item{verbose}{Logical, defaults to \code{FALSE}. Should verbose progress
messages be returned.}
}
\value{
A list as produced by \code{create_stan_data()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
This functions allows the user to more easily specify data driven or model
based priors for \code{\link[=estimate_secondary]{estimate_secondary()}} from example from previous model
fits using a \verb{<data.frame>} to overwrite other default settings. Note that
default settings are still required.
}
\examples{
priors <- data.frame(variable = "frac_obs", mean = 3, sd = 1)
data <- list(obs_scale_mean = 4, obs_scale_sd = 3)
update_secondary_args(data, priors)
}
