% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{plot.dist_spec}
\alias{plot.dist_spec}
\title{Plot PMF and CDF for a dist_spec object}
\usage{
\method{plot}{dist_spec}(x, ...)
}
\arguments{
\item{x}{A \verb{<dist_spec>} object}

\item{...}{Additional arguments to pass to \code{{ggplot}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function takes a \verb{<dist_spec>} object and plots its probability mass
function (PMF) and cumulative distribution function (CDF) using \code{{ggplot2}}.
Note that currently uncertainty in distributions is not plot.
}
\examples{
#' # A fixed lognormal distribution with mean 5 and sd 1.
dist1 <- LogNormal(mean = 1.6, sd = 0.5, max = 20)
plot(dist1)

# An uncertain gamma distribution with mean 3 and sd 2
dist2 <- Gamma(
  mean = Normal(3, 0.5), sd = Normal(2, 0.5), max = 20
)
plot(dist2)

# Multiple distributions
plot(dist1 + dist2 + dist1)

# A combination of the two fixed distributions
plot(dist1 + dist1)
}
