% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_table.R
\name{cleanECDCTable}
\alias{cleanECDCTable}
\title{Cleaning the final table}
\usage{
cleanECDCTable(
  x,
  Country = EpiReport::MSCode$Country,
  GeoCode = EpiReport::MSCode$GeoCode
)
}
\arguments{
\item{x}{dataframe, dataset to clean}

\item{Country}{character vector, full names of the countries /
Member States (e.g. Austria, Belgium, etc.) that will replace the GeoCodes
included the x dataframe (Default \code{MSCode$Country})}

\item{GeoCode}{character vector, corresponding GeoCode of each Member State
(e.g. AT, BE, etc.) to replace with the country full names (Default \code{MSCode$GeoCode})}
}
\value{
cleaned ECDC dataframe
}
\description{
Cleaning the final table: identifying missing reports with \code{'-'},
replacing the Member State codes with Member State names (see correspondence
table \code{\link{MSCode}}), identifying not reporting Member States with \code{'.'}
}
\seealso{
Global function: \code{\link{getTableByMS}} \cr
Default dataset \code{\link{MSCode}}
}
