% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{importAtlasExport}
\alias{importAtlasExport}
\title{Import ECDC Atlas export file (csv)}
\usage{
importAtlasExport(x)
}
\arguments{
\item{x}{file name of a csv file, export from the ECDC Atlas

(e.g. \code{x = 'ECDC_surveillance_data_Anthrax.csv'})}
}
\value{
dataframe
}
\description{
Import ECDC Atlas csv export file \cr
(exported from the online ECDC Atlas:
\href{http://atlas.ecdc.europa.eu/public/index.aspx}{http://atlas.ecdc.europa.eu/public/index.aspx}) \cr
e.g. "ECDC_surveillance_data_Anthrax.csv" \cr
}
\details{
The function will interpret missing reports '-' as NA values
}
\examples{
\donttest{
dataset <- importAtlasExport(x = 'ECDC_surveillance_data_Anthrax.csv')
}


}
\seealso{
\code{\link{cleanAtlasExport}}
}
