% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_distfit.R
\name{expect_distfit}
\alias{expect_distfit}
\title{Test a parametric distribution}
\usage{
expect_distfit(sample, p_value = 0.001, nulldist, ...)
}
\arguments{
\item{sample}{to test}

\item{p_value}{threshold p-value of the test}

\item{nulldist}{null distribution}

\item{...}{parameters to pass to the null distribution}
}
\value{
Invisibly returns a p-value of the test.
}
\description{
Expectation checking whether a given sample comes from a certain parametric distribution. The underlying procedure is Anderson-Darling test of goodness-of-fit \code{\link[goftest]{ad.test}}.
The expectation throws an error when the test's p-value is smaller than the threshold p-value.
}
\examples{

 # Gaussianity test
\dontrun{
x<-rnorm(n=1e4,5,6)
expect_distfit(sample=x, nulldist="pnorm", mean=5, sd=6.3)
expect_distfit(sample=x, nulldist="pnorm", mean=5, sd=6)
}

# Uniformity test
x<-runif(n=1e4,-1,6)
expect_distfit(sample=x, nulldist="punif", min=-1, max=6)

}
