% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterose.R
\name{het}
\alias{het}
\title{Heterosis and Heterobeltiosis}
\usage{
het(GEN, GM, GP, PR, REP, param = "all", verbose = FALSE)
}
\arguments{
\item{GEN}{The column with the genotype name}

\item{GM}{The column with the average of the maternal parent}

\item{GP}{The column with the average of the paternal parent}

\item{PR}{The column with the average of the progeny}

\item{REP}{The column with the repetitions (if exists)}

\item{param}{Value to determine the parameter to be calculated. Default is 'all'.
To calculate heterosis only, use 'het'. To calculate only heterobeltiosis,
use 'hetb'.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Returns heterosis values based on the performance of the tested
parents and progenies. The standard error (SE) is also reported for each
 parameter.
}
\description{
Calculation of heterosis and heterobeltiosis parameters of hybrids
}
\examples{
library(EstimateBreed)

data("maize")
#Extract heterosis and heterobeltiosis
general <- with(maize,het(GEN,GM,GP,PR,REP,param="all"))

#Only extract heterosis
het <- with(maize,het(GEN,GM,GP,PR,REP,param = "het"))

#Extract only heterobeltiosis
hetb <- with(maize,het(GEN,GM,GP,PR,REP,param = "hetb"))
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
