% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_functions.R
\encoding{UTF-8}
\name{half_norm_key}
\alias{half_norm_key}
\title{Half normal key function}
\usage{
half_norm_key(x, sigma)
}
\arguments{
\item{x}{vector of perpendicular distances from the transect.}

\item{sigma}{scale parameter.}
}
\value{
A numeric value corresponding to a given value of \code{x} and
\code{sigma}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function provides the half normal key function for model fitting in
distance sampling.
}
\details{
This is the half normal key function with parameter
\code{sigma}. Its expression is given by

\eqn{g(x) = \exp(\frac{-x^2}{2*\sigma^2},}

for x > 0.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example: Half normal function
half_norm_key(x=1, sigma=4.1058)
curve(half_norm_key(x, sigma=4.1058), from=0, to=20, ylab='g(x)')

#----------------------------------------------------------------------------
}
\seealso{
Other key functions: 
\code{\link{hazard_rate_key}()},
\code{\link{uniform_key}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{key functions}
