% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.maxlogL.R
\encoding{UTF-8}
\name{predict.maxlogL}
\alias{predict.maxlogL}
\title{Predict Method for \code{maxlogL} Fits}
\usage{
\method{predict}{maxlogL}(
  object,
  parameter = NULL,
  newdata = NULL,
  type = c("link", "response", "terms"),
  se.fit = FALSE,
  terms = NULL,
  ...
)
}
\arguments{
\item{object}{an object of \code{maxlogL} class generated by \code{\link{maxlogLreg}}
function.}

\item{parameter}{a character which specifies the parameter to predict.}

\item{newdata}{a data frame with covariates with which to predict. It is an
optional argument, if omitted, the fitted linear predictors or
the (distribution) parameter predictions are used.}

\item{type}{a character with the type of prediction required. The default
(\code{type = "link"}) is on the scale of the linear predictors;
the alternative \code{type = "response"} is on the scale of the
distribution parameter.}

\item{se.fit}{logical switch indicating if standard errors of predictions
are required.}

\item{terms}{A character vector that specifies which terms are required if
\code{type = "terms"}. All terms are returned by default.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If \code{se.fit = FALSE}, a vector of predictions is returned.
For \code{type = "terms"}, a matrix with a column per term and an attribute "constant"
is returned.

If \code{se.fit = TRUE}, a list with the following components is obtained:
\enumerate{
\item \code{fit}: Predictions.
\item \code{se.fit}: Estimated standard errors.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

This function computes predictions and optionally the estimated standard errors
of those predictions from a model fitted with \code{maxlogLreg}.
}
\details{
This \code{predict} method computes predictions for values of any
distribution parameter in link or original scale.
}
\note{
Variables are first looked for in \code{newdata} argument and then searched
in the usual way (which will include the environment of the formula used in
the fit). A warning will be given if the variables found are not of the same
length as those in \code{newdata} if it is supplied.
}
\examples{
library(EstimationTools)

#--------------------------------------------------------------------------------
# Example 1: Predictions from a model using a simulated normal distribution
n <- 1000
x <- runif(n = n, -5, 6)
y <- rnorm(n = n, mean = -2 + 3 * x, sd = exp(1 + 0.3* x))
norm_data <- data.frame(y = y, x = x)

# It does not matter the order of distribution parameters
formulas <- list(sd.fo = ~ x, mean.fo = ~ x)

norm_mod <- maxlogLreg(formulas, y_dist = y ~ dnorm, data = norm_data,
                       link = list(over = "sd", fun = "log_link"))
predict(norm_mod)


#--------------------------------------------------------------------------------
# Example 2: Predictions using new values for covariates
predict(norm_mod, newdata = data.frame(x=0:6))


#--------------------------------------------------------------------------------
# Example 3: Predictions for another parameter
predict(norm_mod, newdata = data.frame(x=0:6), param = "sd",
       type = "response")

#--------------------------------------------------------------------------------
# Example 4: Model terms
predict(norm_mod, param = "sd", type = "terms")


#--------------------------------------------------------------------------------
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
