% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultParser.R
\docType{data}
\name{ResultParser}
\alias{ResultParser}
\title{Parses request and results files returned from our Event Study API
interface.}
\format{\code{\link[R6]{R6Class}} object.}
\usage{
ResultParser
}
\description{
This result file parser works at the moment just for csv files. Please read
the vignette for further details (Coming soon). We will restructure our 
result reports soon. So, this function may change dramatically. This object 
can be used for plotting your results.
}
\section{Methods}{


\describe{
  \item{\code{new(dir)}}{This method is used to create object of this class 
  with \code{dir} as the directory of result files.}
  \item{\code{parseReport(path = "analysis_report.csv")}}{This method 
  parses the analysis report file (analysis_report.csv).}
  \item{\code{parseAR(path = "ar_results.csv")}}{This method parses the 
  abnormal return file (ar_results.csv). Furthermore, it triggers 
  \code{parseReport} and join firm and index name.}
  \item{\code{plotAR(id = NULL)}}{This method abnormal returns time series 
  with \code{id} as the firm id.}}
}

\examples{
\dontrun{
# Assume you already performed an Event Study and result files are saved in 
# the actual working directory.
estParser <- ResultParser$new()

# parse request file
estParser$parseRequestFile("01_RequestFile.csv")

# parse result files
estParser$parseReport("Analysis report.csv")
estParser$parseAR("AR results.csv")
estParser$parseAAR("AAR results.csv")
}

}
\keyword{datasets}
