% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPlots.R
\name{arPlot}
\alias{arPlot}
\title{Abnormal Return Plot}
\usage{
arPlot(
  ResultParserObj,
  firm = NULL,
  window = NULL,
  xlab = "",
  ylab = "Abnormal Returns",
  alpha = 0.5,
  facetVar = NULL,
  ncol = 4,
  addAAR = F,
  xVar = "eventTime",
  yVar = "ar"
)
}
\arguments{
\item{ResultParserObj}{An object of class \code{ResultParser}}

\item{firm}{set this parameter if just a subset of firms should be plotted}

\item{window}{filter event time window}

\item{xlab}{x-axis label of the plot}

\item{ylab}{y-axis label}

\item{alpha}{alpha value}

\item{facetVar}{should each firm get its own plot. You may plot each firm in
an own plot or by each group. (Default: NULL, available: Group and Firm)}

\item{ncol}{number of facet columns}

\item{addAAR}{add aar line}

\item{xVar}{x variable name}

\item{yVar}{y variable name}
}
\value{
a ggplot2 object
}
\description{
Plot abnormal returns in the event window of single or multiple
firms.
}
\examples{
\dontrun{
# plot abnormal returns in one plot
arPlot(resultParser)

# plot abnormal returns by group
arPlot(resultParser, facetVar = "Group")
}

}
