% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logit.R
\name{Logit}
\alias{Logit}
\title{Logit dynamic}
\usage{
Logit(time, state, parameters)
}
\arguments{
\item{time}{Regular sequence that represents the time sequence under which
simulation takes place.}

\item{state}{Numeric vector that represents the initial state.}

\item{parameters}{Numeric vector that represents parameters needed by the
dynamic.}
}
\value{
Numeric list. Each component represents the rate of change depending on
 the dynamic.
}
\description{
Logit dynamic as a type of evolutionary dynamics.
}
\examples{
dynamic <- Logit
A <- matrix(c(0, -2, 1, 1, 0, -2, -2, 1, 0), 3, byrow=TRUE)
state <- matrix(c(0.4, 0.3, 0.3), 1, 3, byrow=TRUE)
eta <- 0.1
phaseDiagram3S(A, dynamic, eta, state, FALSE, FALSE)
}
\references{
Fudenberg, D. and Levine, D. K. (1998)
"The Theory of Learning in Games", MIT Press.
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
