% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclusion_table.R
\name{exclusion_table}
\alias{exclusion_table}
\title{Exclusion Table}
\usage{
exclusion_table(
  data = NULL,
  inclusion_criteria = NULL,
  exclusion_criteria = NULL,
  labels_inclusion = inclusion_criteria,
  labels_exclusion = exclusion_criteria,
  obj = NULL,
  keep_data = TRUE
)
}
\arguments{
\item{data}{A dataframe on which the exclusions are to be performed.}

\item{inclusion_criteria}{A character vector of logical expressions that are used for
inclusions. All individuals who meet these criteria will be included.
Specifically, observations for which the logical expression is \code{FALSE}
will be excluded. Please keep in mind how your expression will handle
\code{NA} values.}

\item{exclusion_criteria}{A character vector of logical expressions that are used for
exclusions. All observations who meet this
criteria will be excluded. Specifically, observations for which the
logical expression is \code{TRUE} will be excluded. Please keep in mind
how your expression will handle \code{NA} values.}

\item{labels_inclusion}{An optional character vector of labels that are used to label the
steps of inclusions. The default labels are the logical expressions
passed to \code{inclusion_criteria}}

\item{labels_exclusion}{An optional character vector of labels that are used to label the
steps of exclusions. The default labels are the logical expressions
passed to \code{exclusion_criteria}.}

\item{obj}{A named list of objects that will be passed to the filtering call.
The list can be access using \verb{obj$<name of object>} in the filtering
call.}

\item{keep_data}{A logical statement to indicate whether the new dataset without the
excluded observations should be outputted. The default is \code{TRUE}.}
}
\value{
\code{exclusion_table} returns a \code{exl_tbl} object which is a list of
data frames including the following information:
\item{\code{table_in}}{a \code{data.frame} including the number of observations
excluded for each inclusion criteria listed in \code{inclusion_criteria}.}
\item{\code{table_ex}}{a \code{data.frame} including the number of observations
excluded for each exclusion criteria listed in \code{exclusion_criteria}.}
\item{\code{dataset}}{a \code{data.frame} of the supplied dataset after applying
all inclusion and exclusion criteria.}
}
\description{
This function keeps track of how many observations you exclude by using
specific inclusion and exclusion criteria. It assumes that your criteria
are logical filter statements, i.e. statements that you would pass to
\code{dplyr::filter()} or to \code{{data.table}}.
}
\examples{
#Example without using the obj argument
exclusion_table(
   data = mtcars,
   exclusion_criteria = c("disp <= 70 | disp >= 300",
                          "as.character(gear) == '4'"),
   labels_exclusion   = c("First exclusion",
                          "Second exclusion")
)

#Example using the obj argument
my_selection <- c(8, 6)

exclusion_table(
  data = mtcars,
  exclusion_criteria = c("cyl \%in\% my_selection"),
  labels_exclusion   = c("First exclusion"),
  obj = list(my_selection = my_selection)
)

}
