\name{print.eba}
\alias{print.eba}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Print Extreme Bounds Analysis Results
%%  ~~function to do ... ~~
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
\code{hist.eba} prints the results of extreme bounds analysis (EBA; performed by the \code{\link{eba}} function) and returns the printed object invisibly (via \code{\link{invisible}(x)}). The function prints out information about the distribution and significance of estimated regression coefficients, the results of Leamer's EBA, as well as those of Sala-i-Martin's EBA (both the normal and generic model).}
\usage{
\method{print}{eba}(x, digits = 3, \dots) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{"eba"}, typically generated by the \code{\link{eba}} function.}
  \item{digits}{number of decimal places to which the output will be rounded.}
  \item{...}{further arguments passed to \code{print.default} and \code{print.data.frame} functions within \code{print.eba}.
  }
%%     ~~Describe \code{\dots} here~~
}
\section{Output}{
\code{print.eba} prints the following information in its output:
\itemize{
\item \code{Call}: the matched call (based on \code{x$call}).
\item \code{Confidence level}: the confidence level for hypothesis testing (\code{x$level}).
\item \code{Number of combinations}: the total number of doubtful variable combinations that contain at least one focus variable (\code{x$ncomb}).
\item \code{Regressions estimated}: the number of regressions that were estimated in the course of EBA (\code{x$nreg}). When no random sampling of regression models was requested (i.e., when \code{eba}'s argument \code{draws} is NULL), the number of combinations (above) will equal the number of regressions estimated.
\item \code{Number of regressions by variable:} the number of regressions estimated, by variable (\code{x$nreg.variable}).
\item \code{Number of coefficients used by variable:} the number of coefficients used in the extreme bounds analysis, by variable (\code{x$ncoef.variable}).
}

Beta coefficients:
\itemize{
\item \code{Coef (Wgt Mean)}: the weighted mean of the estimated regression coefficients. Individual regression models receive a weight specified by \code{\link{eba}}'s argument \code{weights}.
\item \code{SE (Wgt Mean)}: the weighted mean of the standard errors on estimated regression coefficients. Individual regression models receive a weight specified by \code{\link{eba}}'s argument \code{weights}.
\item \code{Min Coef} and \code{SE (Min Coef)}: the value of the lowest regression coefficient across the estimated models and the corresponding standard error.
\item \code{Max Coef} and \code{SE (Max Coef)}: the value of the highest regression coefficient across the estimated models and the corresponding standard error.
}
Distribution of beta coefficients:
\itemize{
\item \code{Pct(beta < mu)}: proportion of estimated regression coefficients whose value is less than \code{mu}.
\item \code{Pct(beta > mu)}: proportion of estimated regression coefficients whose value is greater than \code{mu}.
\item \code{Pct(significant != mu)}: proportion of regression models in which the estimated coefficient is statistically significantly different from \code{mu}.
\item \code{Pct(signif & beta < mu)}: proportion of estimated regression coefficients that are both statistically significantly different from and whose value is less than \code{mu}.
\item \code{Pct(signif & beta > mu)}: proportion of estimated regression coefficients that are both statistically significantly different from and whose value is greater than \code{mu}.
}
Leamer's Extreme Bounds Analysis (EBA):
\itemize{
\item \code{Lower Extreme Bound}: Leamer's lower extreme bound at the specified confidence level.
\item \code{Upper Extreme Bound}: Leamer's upper extreme bound at the specified confidence level.
\item \code{Robust/Fragile?}: a character string indicating whether the variable is robust or fragile based on Leamer's extreme bounds analysis.
}
Sala-i-Martin's Extreme Bounds Analysis (EBA):
\itemize{
\item \code{N: CDF(beta <= 0)}: the value of the cumulative density function at CDF(\code{mu}) - i.e., the proportion of coefficients that are estimated to be lower or equal to \code{mu} - based on Sala-i-Martin's EBA that assumes that regression coefficients are normally distributed across the estimated models. Weights specified by \code{\link{eba}}'s argument \code{weights} are applied.
\item \code{N: CDF(beta > 0)}:  the proportion of coefficients that are estimated to be greater than \code{mu}, based on Sala-i-Martin's EBA that assumes that regression coefficients are normally distributed across the estimated models. Weights specified by \code{\link{eba}}'s argument \code{weights} are applied.
\item \code{G: CDF(beta <= 0)}: the value of the cumulative density function at CDF(\code{mu}) based on Sala-i-Martin's EBA that does not assume any particular distribution of regression coefficients across the estimated models. Weights specified by \code{\link{eba}}'s argument \code{weights} are applied.
\item \code{G: CDF(beta > 0)}: the proportion of coefficients that are estimated to be greater than \code{mu}, based on Sala-i-Martin's EBA that does not assume any particular distribution of regression coefficients across the estimated models. Weights specified by \code{\link{eba}}'s argument \code{weights} are applied.
}
Note that all values of cumulative density functions for Sala-i-Martin's EBA are printed as percentages.
}
\author{
%%  ~~who you are~~
Marek Hlavac   < hlavac at fas.harvard.edu > \cr
Harvard University, Political Economy and Government \cr
}
\section{Please cite as:}{
Hlavac, Marek (2014). ExtremeBounds: Extreme Bounds Analysis in R.\cr
R package version 0.1.4.2. http://CRAN.R-project.org/package=ExtremeBounds 
}
\seealso{
\code{\link{eba}}, \code{\link{hist.eba}}
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
# perform Extreme Bounds Analysis

eba.results <- eba(formula = mpg ~ wt | hp + gear | cyl + disp + drat + qsec + vs + am + carb,
                   data = mtcars[1:10, ], k = 0:2)

# The same result can be achieved by running:
# eba.results <- eba(data = mtcars[1:10, ], y = "mpg", free = "wt",
#                    doubtful = c("cyl","disp","hp","drat","qsec","vs","am","gear","carb"),
#                    focus = c("hp","gear"), k = 0:2)

# print out results, rounded to 2 decimal places
print(eba.results, digits = 2)
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
}
\keyword{ models }
\keyword{ regression }
\keyword{ nonlinear }
\keyword{ robust }
\keyword{ multivariate }

