% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeFileTiff.R
\name{writeFileTiff}
\alias{writeFileTiff}
\title{Write File Tiff}
\usage{
writeFileTiff(img,  file.name, invert = TRUE, bits.per.sample = NULL)
}
\arguments{
\item{img}{Either an image or a list of images. An image is a real matrix or array of three dimensions.}

\item{file.name}{Either the name of the file or the name of a raw vector.}

\item{invert}{If set to TRUE then the order of the data will be reversed. Default TRUE.}

\item{bits.per.sample}{Number of bits per sample (numeric scalar). Supported values in this version are 8, 16, and 32.}
}
\value{
None.
}
\description{
Create a TIFF file from a 3D-array.
}
\details{
Create a TIFF file using writeTIFF, converting a 2D-array. If the file contains multiple pages, a 3D-array is turned into a 2D-array to implement the aforementioned function.
}
\examples{
imagsave <- array(data = 1:10, dim = c(100,100,10))
writeFileTiff(imagsave, paste(tempdir(), "/image_Test.tif", sep = ""))
}
\references{
None
}
\seealso{
\code{\link{writeTIFF}} \code{\link{readFileTiff}}
}
\author{
Adan O. Guerrero Cardenas.
}
