% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuerank_function.R
\name{cuerank}
\alias{cuerank}
\title{Calculate the marginal accuracy of all cues in a dataframe. For each cue, the threshold that maximizes the criterion is selected.}
\usage{
cuerank(formula = NULL, data = NULL, goal = "bacc", sens.w = 0.5,
  numthresh.method = "o", rounding = NULL, verbose = FALSE,
  cue.rules = NULL)
}
\arguments{
\item{formula}{formula. A formula specifying a binary criterion as a function of multiple variables}

\item{data}{dataframe. A dataframe containing variables in formula}

\item{goal}{character. A string indicating the statistic to maximize: "acc" = overall accuracy, "bacc" = balanced accuracy, "wacc" = weighted accuracy, "d" = dprime}

\item{sens.w}{numeric. A number from 0 to 1 indicating how to weight sensitivity relative to specificity.}

\item{numthresh.method}{character. A string indicating how to calculate cue splitting thresholds. "m" = median split, "o" = split that maximizes the goal,}

\item{rounding}{integer. An integer indicating digit rounding for non-integer numeric cue thresholds. The default is NULL which means no rounding. A value of 0 rounds all possible thresholds to the nearest integer, 1 rounds to the nearest .1 (etc.).}

\item{verbose}{logical. A logical value indicating whether or not to print ongoing diagnostics}

\item{cue.rules}{dataframe. An optional df specifying how to make decisions for each cue. Must contain columns "cue", "class", "threshold" and "direction"}
}
\value{
A dataframe containing best thresholds and marginal classification statistics for each cue
}
\description{
Calculate the marginal accuracy of all cues in a dataframe. For each cue, the threshold that maximizes the criterion is selected.
}
\examples{

\dontrun{
 # What are the best thresholds for each cue in the mushrooms dataset?
 mushrooms.cues <- cuerank(formula = poisonous ~.,
                           data = mushrooms)
}


}
